/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class OverwriteDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(OverwriteDialog.class);
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    public static final int YES = 1;
    public static final int YES_FOR_ALL = 2;
    public static final int NO = 3;
    public static final int NO_FOR_ALL = 4;
    private static final int WIDTH = 700;
    private JEditorPane info;
    private ResourceBundle res;
    private URL backgroundImageUrl;
    private int status = 3;
    private int type = 2;

    public OverwriteDialog(final Frame parent, final String title, final ImageIcon icon, int type) throws IOException {
        super((Window)parent, title, true);
        this.type = type;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.init(parent, title, icon);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OverwriteDialog.this.init(parent, title, icon);
                        }
                        catch (Exception oops) {
                            logger.fatal((Object)"OverwriteDialog.OverwriteDialog", (Throwable)oops);
                        }
                    }
                });
            }
        }
        catch (Exception oops) {
            logger.fatal((Object)"OverwriteDialog.OverwriteDialog", (Throwable)oops);
        }
    }

    public void setMessage(String msg) {
        TextServices.setText(this.info, msg, this.backgroundImageUrl);
    }

    private void init(Window parent, String title, ImageIcon icon) throws IOException {
        JiveFactory wm = JiveFactory.getInstance();
        this.res = wm.getResourceBundle();
        this.backgroundImageUrl = wm.getBackgroundImageUrl();
        GridPanel panel = new GridPanel(new Insets(0, 0, 0, 0));
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(panel);
        JLabel background = new JLabel(icon);
        JLabel heading = new JLabel(title);
        Font font = heading.getFont();
        font = font.deriveFont(18.0f);
        heading.setFont(font);
        heading.setForeground(Color.white);
        JLayeredPane headerPane = new JLayeredPane();
        headerPane.setOpaque(true);
        headerPane.setBackground(Color.white);
        headerPane.setPreferredSize(new Dimension(700, 50));
        headerPane.setMinimumSize(new Dimension(700, 50));
        headerPane.setMaximumSize(new Dimension(700, 50));
        headerPane.add((Component)background, new Integer(Integer.MIN_VALUE));
        headerPane.add((Component)heading, new Integer(100));
        background.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        heading.setBounds(20, 0, 700, 50);
        panel.addComponent((JComponent)headerPane, Anchor.NORTHWEST, Fill.HORIZONTAL);
        panel.incrRow();
        this.info = new JEditorPane();
        this.info.setPreferredSize(new Dimension(600, 200));
        this.info.setBackground(Color.white);
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setBackground(Color.white);
        this.info.setEditable(false);
        this.info.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane(this.info);
        scrollPane.setBackground(Color.white);
        panel.addComponent((JComponent)scrollPane, Anchor.NORTHWEST, Fill.BOTH);
        panel.incrRow();
        GridPanel buttonPane = new GridPanel();
        buttonPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton yesButton = new JButton(ResourceServices.getString(this.res, "C_YES"));
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwriteDialog.this.status = 1;
                OverwriteDialog.this.setVisible(false);
                OverwriteDialog.this.dispose();
            }
        });
        JButton yesForAllButton = null;
        if (this.type == 2) {
            yesForAllButton = new JButton(ResourceServices.getString(this.res, "C_YES_FOR_ALL"));
            yesForAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OverwriteDialog.this.status = 2;
                    OverwriteDialog.this.setVisible(false);
                    OverwriteDialog.this.dispose();
                }
            });
        }
        JButton noButton = new JButton(ResourceServices.getString(this.res, "C_NO"));
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwriteDialog.this.status = 3;
                OverwriteDialog.this.setVisible(false);
                OverwriteDialog.this.dispose();
            }
        });
        JButton noForAllButton = null;
        if (this.type == 2) {
            noForAllButton = new JButton(ResourceServices.getString(this.res, "C_NO_FOR_ALL"));
            noForAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OverwriteDialog.this.status = 4;
                    OverwriteDialog.this.setVisible(false);
                    OverwriteDialog.this.dispose();
                }
            });
        }
        buttonPane.addComponent((JComponent)yesButton, Anchor.CENTER);
        if (this.type == 2) {
            buttonPane.addComponent((JComponent)yesForAllButton, Anchor.CENTER);
        }
        buttonPane.addComponent((JComponent)noButton, Anchor.CENTER);
        if (this.type == 2) {
            buttonPane.addComponent((JComponent)noForAllButton, Anchor.CENTER);
        }
        panel.addComponent((JComponent)buttonPane, Anchor.CENTER, Fill.HORIZONTAL);
    }

    public int getStatus() {
        return this.status;
    }
}

