/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.model.MarginSet;
import org.dbdoclet.jive.model.SpinnerDistanceModel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class MarginChooser
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int STANDARD = 1;
    public static final int MONOSPACED = 2;
    private boolean canceled = false;
    private JButton cancelButton;
    private JSpinner spaceBeforeSpinner;
    private ResourceBundle res;
    private JiveFactory wm;
    private JSpinner spaceAfterSpinner;

    public static void main(String[] args) {
        JiveFactory.getInstance(Locale.getDefault());
        MarginChooser dlg = new MarginChooser(null, null);
        dlg.createGui();
        dlg.setVisible(true);
    }

    public MarginChooser(Frame frame, MarginSet marginSet) {
        super((Window)frame, "MarginChooser", true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase("cancel")) {
            this.setCanceled(true);
            this.setVisible(false);
        }
        if (cmd.equalsIgnoreCase("ok")) {
            this.setCanceled(false);
            this.setVisible(false);
        }
    }

    public void createGui() {
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        GridPanel panel = new GridPanel();
        this.getRootPane().setContentPane(panel);
        panel.addSeparator(2, ResourceServices.getString(this.res, "C_SPACING"));
        panel.incrRow();
        this.spaceBeforeSpinner = new JSpinner(new SpinnerDistanceModel(this.wm.getLocale()));
        panel.addLabeledComponent(ResourceServices.getString(this.res, "C_BEFORE"), (JComponent)this.spaceBeforeSpinner);
        panel.incrRow();
        this.spaceAfterSpinner = new JSpinner(new SpinnerDistanceModel(this.wm.getLocale()));
        panel.addLabeledComponent(ResourceServices.getString(this.res, "C_AFTER"), (JComponent)this.spaceAfterSpinner);
        JButton okButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_OK"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        panel.addButton(okButton);
        this.cancelButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_CANCEL"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        panel.addButton(this.cancelButton);
        panel.prepare();
        this.pack();
        this.center();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

