/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class ListChooser<E>
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final int STANDARD = 1;
    public static final int MONOSPACED = 2;
    private ResourceBundle res;
    private JiveFactory wm;
    private String description = "";
    private final Object[] modelData;
    private JList<?> list;
    private E value;

    public static void main(String[] args) {
        JiveFactory.getInstance(Locale.getDefault());
        ListChooser<String> dlg = new ListChooser<String>(null, new String[]{"Dodo", "Strau\u00df", "Emu", "Nachtigall"});
        dlg.setDescription("<html><p>Lorem ispum sed dolor amet.<br> Lorem ispum sed dolor amet.");
        dlg.createGui();
        dlg.setVisible(true);
        String text = dlg.getValue();
        System.out.println(text);
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ListChooser(Frame frame, E[] modelData) {
        super((Window)frame, "ListChooser", true);
        this.modelData = modelData;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase("cancel")) {
            this.setPerformedAction(DialogAction.CANCEL);
            this.setVisible(false);
        }
        if (cmd.equalsIgnoreCase("ok")) {
            this.setPerformedAction(DialogAction.OK);
            this.setVisible(false);
        }
    }

    public void createGui() {
        this.wm = JiveFactory.getInstance();
        this.res = this.wm.getResourceBundle();
        GridPanel panel = new GridPanel();
        this.getRootPane().setContentPane(panel);
        panel.startSubPanel();
        JLabel label = new JLabel(this.description);
        label.setFont(label.getFont().deriveFont(0));
        panel.addComponent(label);
        panel.startSubPanel(Fill.HORIZONTAL);
        this.list = new JList<Object>(this.modelData);
        this.list.addListSelectionListener(this);
        panel.addComponent((JComponent)new JScrollPane(this.list), Anchor.NORTHWEST, Fill.HORIZONTAL);
        panel.incrRow();
        JButton okButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_OK"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        panel.addButton(okButton);
        JButton cancelButton = this.wm.createButton(null, ResourceServices.getString(this.res, "C_CANCEL"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        panel.addButton(cancelButton);
        panel.prepare();
        this.pack();
        this.center();
    }

    public boolean isCanceled() {
        return this.getPerformedAction() == DialogAction.CANCEL;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.value = this.list.getSelectedValue();
    }
}

