/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.widget.UpperCaseTextField;
import org.dbdoclet.service.ResourceServices;

public class LicenseKeyDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JiveFactory widgetMap = JiveFactory.getInstance();
    private ResourceBundle res = this.widgetMap.getResourceBundle();
    private JTextComponent text;
    private UpperCaseTextField entry1;
    private UpperCaseTextField entry2;
    private UpperCaseTextField entry3;
    private UpperCaseTextField entry4;
    private UpperCaseTextField entry5;
    private JButton okButton;

    public LicenseKeyDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setTitle(ResourceServices.getString(this.res, "C_LICENSE_KEY"));
        this.createUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(width, height);
        this.setLocation((dimension.width - width) / 2, (dimension.height - height) / 2);
    }

    public String getLicenseKey() {
        String licenseKey = this.entry1.getText() + "-" + this.entry2.getText() + "-" + this.entry3.getText() + "-" + this.entry4.getText() + "-" + this.entry5.getText();
        return licenseKey;
    }

    public void failed() {
        this.text.setText(ResourceServices.getString(this.res, "C_ERROR_INVALID_LICENSE"));
        this.text.setForeground(Color.red);
        this.invalidate();
    }

    public void reset() {
        this.entry1.setText("");
        this.entry2.setText("");
        this.entry3.setText("");
        this.entry4.setText("");
        this.entry5.setText("");
    }

    private void createUI() {
        JPanel buttonPanel = this.createButtonPanel();
        JPanel licensePanel = this.createLicensePanel();
        JPanel panel = this.widgetMap.createPanel(new Identifier("jive.dialog.license-key"));
        this.getContentPane().add(panel);
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new EtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        int col = 0;
        gbc.ipady = 6;
        gbc.ipadx = 6;
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.insets = new Insets(8, 8, 8, 8);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.text = this.widgetMap.createHelpArea(null, panel, ResourceServices.getString(this.res, "C_ENTER_LICENSE_KEY"));
        panel.add((Component)this.text, gbc);
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        panel.add((Component)licensePanel, gbc);
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        panel.add((Component)buttonPanel, gbc);
        this.pack();
    }

    private JPanel createLicensePanel() {
        JPanel panel = this.widgetMap.createPanel(new Identifier("jive.license-key.license"));
        this.entry5 = this.widgetMap.createUpperCaseTextField(new Identifier("jive.license.value5"), 5);
        this.entry5.setMaxLength(5);
        this.entry5.setNext(this.okButton);
        this.entry4 = this.widgetMap.createUpperCaseTextField(new Identifier("jive.license.value4"), 5);
        this.entry4.setMaxLength(5);
        this.entry4.setNext(this.entry5);
        this.entry3 = this.widgetMap.createUpperCaseTextField(new Identifier("jive.license.value3"), 5);
        this.entry3.setMaxLength(5);
        this.entry3.setNext(this.entry4);
        this.entry2 = this.widgetMap.createUpperCaseTextField(new Identifier("jive.license.value2"), 5);
        this.entry2.setMaxLength(5);
        this.entry2.setNext(this.entry3);
        this.entry1 = this.widgetMap.createUpperCaseTextField(new Identifier("jive.license.value1"), 5);
        this.entry1.setMaxLength(5);
        this.entry1.setNext(this.entry2);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        int col = 0;
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.entry1, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JLabel label = this.widgetMap.createLabel(new Identifier("jive.license.label1"), "-");
        panel.add((Component)label, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.entry2, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        label = this.widgetMap.createLabel(new Identifier("jive.license.label2"), "-");
        panel.add((Component)label, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.entry3, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        label = this.widgetMap.createLabel(new Identifier("jive.license.label3"), "-");
        panel.add((Component)label, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.entry4, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        label = this.widgetMap.createLabel(new Identifier("jive.license.label4"), "-");
        panel.add((Component)label, gbc);
        gbc.gridx = col++;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.entry5, gbc);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = this.widgetMap.createPanel(new Identifier("jive.license.buttons"));
        this.okButton = this.widgetMap.createButton(new Identifier("jive.license.ok"), ResourceServices.getString(this.res, "C_OK"));
        panel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseKeyDialog.this.setVisible(false);
            }
        });
        return panel;
    }
}

