/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.DataDialog;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.service.ResourceServices;

public class InputDialog
extends DataDialog {
    private static final long serialVersionUID = 1L;
    private String value = "";
    private String label = "";
    private JTextField entry;
    private JLabel description;

    public InputDialog(Frame parent, String title) {
        super(parent, title);
        this.init(parent);
    }

    public InputDialog(Frame parent, String title, boolean isModal) {
        super(parent, title, isModal);
        this.init(parent);
    }

    private void init(Frame parent) {
        JiveFactory wm = JiveFactory.getInstance();
        ResourceBundle res = wm.getResourceBundle();
        GridPanel g = super.getGridPanel();
        JPanel panel = new JPanel();
        this.description = new JLabel();
        this.entry = new JTextField();
        Font f = this.entry.getFont();
        this.entry.setPreferredSize(new Dimension(300, f.getSize() + 8));
        this.entry.setAlignmentY(0.5f);
        this.entry.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                InputDialog.this.value = InputDialog.this.entry.getText();
                InputDialog.this.setVisible(false);
            }
        });
        panel.add(this.description);
        panel.add(this.entry);
        GridPanel buttons = new GridPanel();
        JButton ok = new JButton(ResourceServices.getString(res, "C_OK"));
        ok.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                InputDialog.this.value = InputDialog.this.entry.getText();
                InputDialog.this.setVisible(false);
                InputDialog.this.setPerformedAction(DialogAction.OK);
            }
        });
        JButton cancel = new JButton(ResourceServices.getString(res, "C_CANCEL"));
        cancel.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                InputDialog.this.setVisible(false);
                InputDialog.this.setPerformedAction(DialogAction.CANCEL);
            }
        });
        buttons.addComponent((JComponent)ok, Anchor.WEST);
        buttons.addComponent((JComponent)cancel, Anchor.EAST);
        g.addComponent((JComponent)panel, Anchor.CENTER, Fill.BOTH);
        g.incrRow();
        g.addComponent((JComponent)buttons, Anchor.WEST, Fill.HORIZONTAL);
        this.pack();
        this.center(parent);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.entry.setText(value);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.description.setText(label);
    }

    @Override
    public boolean isCanceled() {
        return this.getPerformedAction() == DialogAction.CANCEL;
    }
}

