/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.View;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.dialog.action.ActionCloseDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.ButtonPanel;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.TopPanel;

public class InfoDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String buttonPressed = "";
    private Font font;
    private JEditorPane info;
    private GridPanel panel;
    private TopPanel topPanel;
    private int buttonMask = DialogAction.getFlag(DialogAction.OK);
    private final String text;

    public InfoDialog(Window parent, String title, String text) {
        super(parent, title, true);
        this.text = text;
    }

    public InfoDialog(Window parent, String title, String msg, int buttonMask) {
        this(parent, title, msg);
        this.buttonMask = buttonMask;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event != null && event.getSource() instanceof JButton) {
            this.buttonPressed = event.getActionCommand();
            if (this.buttonPressed.equals("ok")) {
                this.setPerformedAction(DialogAction.OK);
            }
            if (this.buttonPressed.equals("cancel")) {
                this.setPerformedAction(DialogAction.CANCEL);
            }
            if (this.buttonPressed.equals("yes")) {
                this.setPerformedAction(DialogAction.YES);
            }
            if (this.buttonPressed.equals("no")) {
                this.setPerformedAction(DialogAction.NO);
            }
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public GridPanel getPanel() {
        return this.panel;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public void setGradient(Color gradientColorFrom, Color gradientColorTo) {
        this.topPanel.setGradient(gradientColorFrom, gradientColorTo);
    }

    public void setHeaderBackground(Color headerBackground) {
        this.topPanel.setBackground(headerBackground);
    }

    @Override
    protected void init() {
        JButton cancelButton;
        JButton noButton;
        JButton yesButton;
        super.init();
        this.panel = new GridPanel(new Insets(0, 0, 0, 0));
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(this.panel);
        this.topPanel = this.createTopPanel(this.getTitle());
        this.panel.addComponent((JComponent)this.topPanel, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.info = new JEditorPane();
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setBackground(Color.white);
        this.info.setEditable(false);
        this.info.setFocusable(false);
        if (this.font != null) {
            this.info.setFont(this.font);
        }
        TextServices.setText(this.info, this.text);
        int lines = TextServices.countLines(this.text);
        if (lines < 40) {
            View view = this.info.getUI().getRootView(this.info);
            view.setSize(640.0f, 2.1474836E9f);
            int preferredHeight = (int)view.getPreferredSpan(1);
            this.info.setPreferredSize(new Dimension(660, preferredHeight + 20));
        } else {
            this.info.setPreferredSize(new Dimension(660, 820));
        }
        JScrollPane scrollPane = new JScrollPane(this.info);
        scrollPane.setBackground(Color.white);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panel.addComponent((JComponent)scrollPane, Anchor.NORTHWEST, Fill.BOTH);
        this.panel.incrRow();
        ButtonPanel buttonPanel = new ButtonPanel(this.buttonMask, this);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton okButton = buttonPanel.getOkButton();
        if (okButton != null) {
            okButton.addActionListener(new ActionCloseDialog(this, "ok"));
            this.getRootPane().setDefaultButton(okButton);
        }
        if ((yesButton = buttonPanel.getYesButton()) != null) {
            yesButton.addActionListener(new ActionCloseDialog(this, "yes"));
        }
        if ((noButton = buttonPanel.getNoButton()) != null) {
            noButton.addActionListener(new ActionCloseDialog(this, "no"));
        }
        if ((cancelButton = buttonPanel.getCancelButton()) != null) {
            cancelButton.addActionListener(new ActionCloseDialog(this, "cancel"));
        }
        this.panel.addComponent((JComponent)buttonPanel, Anchor.CENTER, Fill.HORIZONTAL);
        this.pack();
        this.center(this.getParentWindow());
    }
}

