/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.TopPanel;
import org.dbdoclet.service.ResourceServices;

public class ExceptionBox
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int BORDER_SIZE = 5;
    private boolean showDetails = true;
    private JScrollPane detailsPane;
    private JButton detailsButton;

    public ExceptionBox(Throwable oops) {
        super((Window)null, "ExceptionBox", true);
        if (oops == null) {
            oops = new Throwable();
        }
        this.createDialog(null, null, oops);
        this.center();
    }

    public ExceptionBox(String title, Throwable oops) {
        super((Window)null, title, true);
        if (oops == null) {
            oops = new Throwable();
        }
        this.createDialog(title, null, oops);
        this.center();
    }

    public ExceptionBox(String title, String msg, Throwable oops) {
        super((Window)null, title, true);
        if (oops == null) {
            oops = new Throwable();
        }
        this.createDialog(title, msg, oops);
        this.center();
    }

    public ExceptionBox(Frame parent, Throwable oops) {
        this(parent, null, null, oops);
    }

    public ExceptionBox(Frame parent, String title, Throwable oops) {
        this(parent, title, null, oops);
    }

    public ExceptionBox(Frame parent, String title, String msg, Throwable oops) {
        super((Window)parent, "Exception", true);
        if (oops == null) {
            oops = new Throwable();
        }
        this.createDialog(title, msg, oops);
        this.center(parent);
    }

    public ExceptionBox(Dialog parent, Throwable oops) {
        this(parent, null, null, oops);
    }

    public ExceptionBox(Dialog parent, String title, String msg, Throwable oops) {
        super((Window)parent, "Exception", true);
        if (oops == null) {
            oops = new Throwable();
        }
        this.createDialog(title, msg, oops);
        this.center(parent);
    }

    private void createDialog(String title, String msg, Throwable oops) {
        if (title != null && title.length() > 0) {
            this.setTitle(title);
        }
        JiveFactory jf = JiveFactory.getInstance();
        ResourceBundle res = jf.getResourceBundle();
        GridPanel panel = new GridPanel(new Insets(0, 0, 0, 0));
        this.getContentPane().add(panel);
        panel.setLayout(new GridBagLayout());
        TopPanel topPanel = this.createTopPanel("Exception: " + oops.getClass().getSimpleName());
        topPanel.setGradient(JiveConstants.COLOUR_RED_1, JiveConstants.COLOUR_RED_4);
        panel.addComponent((JComponent)topPanel, Colspan.CS_2, Anchor.NORTHWEST, Fill.HORIZONTAL);
        panel.incrRow();
        JLabel label = jf.createLabel(" " + ResourceServices.getString(res, "C_MESSAGE") + ":");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.addComponent(label);
        if (msg == null || msg.length() == 0) {
            msg = oops.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        label = jf.createLabel(" " + msg, 0);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.addComponent(label);
        panel.incrRow();
        label = jf.createLabel(" " + ResourceServices.getString(res, "C_CLASS") + ":");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.addComponent(label);
        label = jf.createLabel(" " + oops.getClass().getName(), 0);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.addComponent(label);
        panel.incrRow();
        JTextArea detailsArea = jf.createTextArea(new Identifier("details"));
        detailsArea.setEditable(false);
        this.detailsPane = jf.createScrollPane(detailsArea);
        String areaText = "";
        StringWriter buffer = new StringWriter();
        oops.printStackTrace(new PrintWriter(buffer));
        areaText = buffer.toString();
        for (Throwable cause = oops.getCause(); cause != null; cause = cause.getCause()) {
            buffer = new StringWriter();
            cause.printStackTrace(new PrintWriter(buffer));
            areaText = areaText + buffer.toString();
        }
        detailsArea.setText(areaText);
        detailsArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.addComponent((JComponent)this.detailsPane, Colspan.CS_2, Anchor.NORTHWEST, Fill.BOTH);
        panel.incrRow();
        JPanel buttonPanel = jf.createPanel(null);
        JButton closeButton = jf.createButton(null, ResourceServices.getString(res, "C_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionBox.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.showDetails) {
            this.detailsButton = jf.createButton(new Identifier("jive.dialog.exception.details"), ResourceServices.getString(res, "C_HIDE_DETAILS"));
        } else {
            this.detailsButton = jf.createButton(new Identifier("jive.dialog.exception.details"), ResourceServices.getString(res, "C_SHOW_DETAILS"));
            detailsArea.setVisible(false);
        }
        this.detailsButton.addActionListener(this);
        this.detailsButton.setActionCommand("details");
        buttonPanel.add(this.detailsButton);
        panel.addVerticalGlue();
        panel.incrRow();
        panel.addComponent((JComponent)buttonPanel, Colspan.CS_2, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JiveFactory widgetMap = JiveFactory.getInstance();
        ResourceBundle res = widgetMap.getResourceBundle();
        String cmd = event.getActionCommand();
        if (cmd != null && cmd.equals("details")) {
            if (this.showDetails) {
                this.showDetails = false;
                this.detailsPane.setVisible(false);
                this.detailsButton.setText(ResourceServices.getString(res, "C_SHOW_DETAILS"));
                this.pack();
            } else {
                this.showDetails = true;
                this.detailsPane.setVisible(true);
                this.detailsButton.setText(ResourceServices.getString(res, "C_HIDE_DETAILS"));
                this.pack();
            }
        }
    }
}

