/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.FileAccessDeniedException;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.dialog.InfoDialog;
import org.dbdoclet.service.ResourceServices;

public class ErrorBox
extends InfoDialog {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(ErrorBox.class);

    public ErrorBox(Frame parent, String title, String msg) {
        super((Window)parent, title, msg);
    }

    @Override
    protected void init() {
        super.init();
        this.setGradient(JiveConstants.COLOUR_FIREBRICK_1, JiveConstants.COLOUR_FIREBRICK_4);
    }

    public static void show(String error, String msg) {
        ErrorBox.show(null, error, msg);
    }

    public static void show(Window parent, String error, String msg) {
        try {
            if (error == null) {
                throw new IllegalArgumentException("The argument error may not be null!");
            }
            if (msg == null) {
                throw new IllegalArgumentException("The argument msg may not be null!");
            }
            InfoDialog dlg = null;
            if (parent instanceof Frame) {
                dlg = new InfoDialog(parent, error, msg);
            }
            if (parent instanceof Dialog) {
                dlg = new InfoDialog(parent, error, msg);
            }
            if (dlg == null) {
                dlg = new InfoDialog((Window)null, error, msg);
            }
            dlg.init();
            dlg.setGradient(JiveConstants.COLOUR_FIREBRICK_1, JiveConstants.COLOUR_FIREBRICK_4);
            dlg.pack();
            dlg.center(parent);
            dlg.setVisible(true);
            dlg.toFront();
            logger.error((Object)msg);
        }
        catch (Throwable oops) {
            oops.printStackTrace();
            JOptionPane.showMessageDialog(parent, msg, error, 0);
        }
    }

    public static void show(Throwable oops) {
        ErrorBox.show(null, oops);
    }

    public static void show(Frame parent, Throwable oops) {
        JiveFactory wm = JiveFactory.getInstance();
        ResourceBundle res = wm.getResourceBundle();
        if (oops instanceof FileAccessDeniedException) {
            String msg = MessageFormat.format(ResourceServices.getString(res, "C_ERROR_FILE_ACCESS_DENIED"), ((FileAccessDeniedException)oops).getFile().getAbsolutePath());
            ErrorBox.show(parent, ResourceServices.getString(res, "C_ERROR"), msg);
            return;
        }
        ExceptionBox ebox = new ExceptionBox(oops);
        ebox.setVisible(true);
        ebox.toFront();
    }
}

