/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Colspan;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.Rowspan;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.ExceptionBox;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.ImagePreview;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ResourceServices;

public class DeleteImagesDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> imageList;
    private JiveFactory wmap;
    private ResourceBundle res;
    private File dir;
    private int index;
    private boolean canceled = false;
    private JLabel dirLabel;
    private JLabel dirBox;
    private JLabel fileNameLabel;
    private JComboBox<String> fileNameBox;
    private ImagePreview imagePreview;
    private JButton cancel;
    private JButton delete;
    private JButton deleteAll;
    private JButton next;

    public DeleteImagesDialog(Frame parent, File dir, ArrayList<String> imageList, String infoText) {
        super((Window)parent, "");
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (imageList == null) {
            throw new IllegalArgumentException("The argument imageList must not be null!");
        }
        try {
            Collections.sort(imageList);
            this.wmap = JiveFactory.getInstance();
            this.res = this.wmap.getResourceBundle();
            this.dir = dir;
            this.imageList = imageList;
            this.setTitle(ResourceServices.getString(this.res, "C_DELETE_IMAGES"));
            this.index = 0;
            GridPanel panel = new GridPanel();
            this.imagePreview = new ImagePreview();
            if (infoText != null) {
                panel.addComponent((JComponent)this.wmap.createHelpArea(null, panel, infoText), Anchor.NORTHWEST, Fill.HORIZONTAL);
                panel.incrRow();
            }
            this.dirLabel = this.wmap.createLabel(null, ResourceServices.getString(this.res, "C_DIRECTORY"));
            String buffer = dir.getCanonicalPath();
            if (buffer.length() > 80) {
                buffer = "..." + buffer.substring(buffer.length() - 80);
            }
            this.dirBox = this.wmap.createLabel(null, buffer, 0);
            this.fileNameLabel = this.wmap.createLabel(null, ResourceServices.getString(this.res, "C_FILE_NAME"));
            if (imageList.size() > 0) {
                String[] list = new String[imageList.size()];
                imageList.toArray(list);
                this.fileNameBox = this.wmap.createComboBox(new Identifier("images"), list);
                this.updatePreview();
            } else {
                this.fileNameBox = this.wmap.createComboBox(new Identifier("images"));
            }
            this.fileNameBox.setActionCommand("select");
            this.fileNameBox.addActionListener(this);
            this.delete = new JButton(ResourceServices.getString(this.res, "C_DELETE"));
            this.delete.setActionCommand("delete");
            this.delete.addActionListener(this);
            this.deleteAll = new JButton(ResourceServices.getString(this.res, "C_DELETE_ALL"));
            this.deleteAll.setActionCommand("delete-all");
            this.deleteAll.addActionListener(this);
            this.next = new JButton(ResourceServices.getString(this.res, "C_NEXT"));
            this.next.setActionCommand("next");
            this.next.addActionListener(this);
            this.cancel = new JButton(ResourceServices.getString(this.res, "C_CANCEL"));
            this.cancel.setActionCommand("cancel");
            this.cancel.addActionListener(this);
            panel.addComponent(this.dirLabel);
            panel.addComponent(this.dirBox);
            panel.incrRow();
            panel.addComponent(this.fileNameLabel);
            panel.addComponent(this.fileNameBox);
            panel.incrRow();
            GridPanel previewPanel = new GridPanel();
            previewPanel.addComponent((JComponent)this.imagePreview, Anchor.CENTER, Fill.BOTH);
            panel.addComponent((JComponent)previewPanel, Anchor.CENTER, Fill.BOTH);
            panel.incrRow();
            GridPanel buttonPanel = new GridPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            buttonPanel.addComponent(this.next);
            buttonPanel.addComponent(this.delete);
            buttonPanel.addComponent(this.deleteAll);
            buttonPanel.addComponent(this.cancel);
            panel.addComponent(buttonPanel, Colspan.CS_2, Rowspan.RS_1, Anchor.CENTER, Fill.HORIZONTAL);
            if (imageList.size() == 0) {
                this.next.setEnabled(false);
                this.delete.setEnabled(false);
                this.deleteAll.setEnabled(false);
            }
            this.getContentPane().add((Component)panel, "Center");
            this.pack();
            this.center();
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String cmd = actionEvent.getActionCommand();
            if (cmd.equals("cancel")) {
                this.setVisible(false);
                this.canceled = true;
                this.dispose();
                return;
            }
            if (cmd.equals("delete-all")) {
                for (int i = 0; i < this.imageList.size(); ++i) {
                    FileServices.delete(this.getImageFile(i));
                }
                this.setVisible(false);
                this.canceled = false;
                this.dispose();
                return;
            }
            if (cmd.equals("delete")) {
                this.delete(this.index);
                return;
            }
            if (cmd.equals("select")) {
                this.index = this.fileNameBox.getSelectedIndex();
                if (this.index == -1 || this.index >= this.imageList.size()) {
                    return;
                }
                this.imagePreview.setImage(this.getImageFile(this.index));
                return;
            }
            if (cmd.equals("next")) {
                this.index = this.index >= this.imageList.size() - 1 ? 0 : ++this.index;
                this.fileNameBox.setSelectedIndex(this.index);
                this.updatePreview();
            }
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
            this.index = 0;
            if (this.imageList.size() > 0) {
                this.imagePreview.setImage(this.getImageFile(this.index));
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private File getImageFile(int index) {
        if (index < 0 || index >= this.imageList.size()) {
            return null;
        }
        String imageFileName = this.imageList.get(index);
        if (imageFileName == null || imageFileName.trim().length() == 0) {
            return null;
        }
        imageFileName = FileServices.appendFileName(this.dir, imageFileName);
        imageFileName = FileServices.normalizePath(imageFileName);
        File imageFile = new File(imageFileName);
        return imageFile;
    }

    private void updatePreview() {
        File file = this.getImageFile(this.index);
        if (file != null) {
            this.imagePreview.setImage(file);
        }
    }

    private void delete(int index) throws Exception {
        if (index < 0 || index >= this.imageList.size()) {
            return;
        }
        int selected = this.fileNameBox.getSelectedIndex();
        if (index != selected) {
            this.fileNameBox.setSelectedIndex(index);
            this.imagePreview.setImage(this.getImageFile(index));
        }
        FileServices.delete(this.getImageFile(index));
        this.imageList.remove(index);
        if (this.imageList.size() == 0) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.fileNameBox.removeItemAt(index);
        this.fileNameBox.setSelectedIndex(index);
        this.imagePreview.setImage(this.getImageFile(index));
    }
}

