/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.TopPanel;

public class DataDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private GridPanel gridPanel;
    protected JLabel errorLabel;
    protected ImageIcon hintIcon;

    public DataDialog(Frame parent, String title) {
        super((Window)parent, title, true);
        this.init(title);
    }

    public DataDialog(Frame parent, String title, boolean isModal) {
        super((Window)parent, title, isModal);
        this.init(title);
    }

    public DataDialog(Dialog parent, String title, boolean isModal) {
        super((Window)parent, title, isModal);
        this.init(title);
    }

    protected GridPanel getGridPanel() {
        return this.gridPanel;
    }

    protected void setError(String message) {
        this.errorLabel.setText(message);
        if (this.hintIcon != null) {
            this.errorLabel.setIcon(this.hintIcon);
        }
    }

    protected void unsetError() {
        this.errorLabel.setIcon(null);
        this.errorLabel.setText(" ");
    }

    private void init(String title) {
        GridPanel rootPanel = new GridPanel(new Insets(0, 0, 0, 0));
        rootPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)rootPanel, "Center");
        TopPanel topPanel = this.createTopPanel(title);
        this.errorLabel = new JLabel();
        this.errorLabel.setText(" ");
        this.errorLabel.setFont(this.errorLabel.getFont().deriveFont(1));
        this.errorLabel.setForeground(JiveConstants.COLOUR_FIREBRICK_4);
        rootPanel.addComponent((JComponent)topPanel, Anchor.NORTHWEST, Fill.HORIZONTAL);
        rootPanel.incrRow();
        rootPanel.addComponent((JComponent)this.errorLabel, Anchor.NORTHWEST, Fill.HORIZONTAL);
        rootPanel.incrRow();
        this.gridPanel = new GridPanel();
        rootPanel.addComponent((JComponent)this.gridPanel, Anchor.NORTHWEST, Fill.BOTH);
    }

    public boolean isCanceled() {
        return this.getPerformedAction() == DialogAction.CANCEL;
    }
}

