/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.View;
import org.dbdoclet.jive.Anchor;
import org.dbdoclet.jive.Fill;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.dialog.action.ActionCloseDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.TopPanel;
import org.dbdoclet.service.ResourceServices;

public class ContinueDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private ResourceBundle res;
    private JEditorPane info;
    private GridPanel panel;
    private boolean doContinue = false;
    private JButton continueButton;
    private JButton cancelButton;
    private TopPanel topPanel;

    public ContinueDialog(Dialog parent, String title, String question) throws IOException {
        super((Window)parent, title, true);
        this.init(parent, title, question);
    }

    public ContinueDialog(Frame parent, String title, String question) throws IOException {
        super((Window)parent, title, true);
        this.init(parent, title, question);
    }

    public boolean doContinue() {
        return this.doContinue;
    }

    private void init(Window parent, String title, String question) throws IOException {
        JiveFactory wm = JiveFactory.getInstance();
        this.res = wm.getResourceBundle();
        this.panel = new GridPanel(new Insets(0, 0, 0, 0));
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(this.panel);
        this.topPanel = this.createTopPanel(title);
        this.topPanel.setGradient(JiveConstants.COLOUR_DARK_ORANGE, JiveConstants.COLOUR_DARK_ORANGE_4);
        this.panel.addComponent((JComponent)this.topPanel, Anchor.NORTHWEST, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.info = new JEditorPane();
        this.info.setBackground(Color.white);
        this.info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.info.setBackground(Color.white);
        this.info.setEditable(false);
        this.info.setFocusable(false);
        TextServices.setText(this.info, question);
        View view = this.info.getUI().getRootView(this.info);
        view.setSize(640.0f, 2.1474836E9f);
        int preferredHeight = (int)view.getPreferredSpan(1);
        this.info.setPreferredSize(new Dimension(654, preferredHeight + 14));
        JScrollPane scrollPane = new JScrollPane(this.info);
        scrollPane.setBackground(Color.white);
        this.panel.addComponent((JComponent)scrollPane, Anchor.NORTHWEST, Fill.BOTH);
        this.panel.incrRow();
        GridPanel buttonPane = new GridPanel();
        buttonPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.continueButton = new JButton(ResourceServices.getString(this.res, "C_CONTINUE"));
        this.continueButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ContinueDialog.this.doContinue = true;
                ContinueDialog.this.setVisible(false);
            }
        });
        buttonPane.addComponent((JComponent)this.continueButton, Anchor.CENTER, Fill.NONE);
        this.cancelButton = new JButton(ResourceServices.getString(this.res, "C_CANCEL"));
        this.cancelButton.addActionListener(new ActionCloseDialog(this, "cancel-dialog"));
        buttonPane.addComponent((JComponent)this.cancelButton, Anchor.CENTER, Fill.NONE);
        this.panel.addComponent((JComponent)buttonPane, Anchor.CENTER, Fill.HORIZONTAL);
        this.panel.incrRow();
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.pack();
        this.center(parent);
    }

    public void setCancelButtonText(String cancelButtonText) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(cancelButtonText);
        }
    }

    public void setContinueButtonText(String continueButtonText) {
        if (this.continueButton != null) {
            this.continueButton.setText(continueButtonText);
        }
    }
}

