/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.dbdoclet.format.Alignment;
import org.dbdoclet.jive.JiveConstants;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.JiveServices;
import org.dbdoclet.jive.dialog.DialogAction;
import org.dbdoclet.jive.dialog.action.ActionCloseDialog;
import org.dbdoclet.jive.widget.TopPanel;

public class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private DialogAction performedAction = DialogAction.NONE;
    private final Window parent;
    protected static final int PREFERRED_HEIGHT = 800;
    protected static final int PREFERRED_WIDTH = 640;
    protected ResourceBundle res;
    private boolean initialized;

    public AbstractDialog() {
        this((Window)null, "", true);
    }

    public AbstractDialog(String title) {
        this((Window)null, title, true);
    }

    public AbstractDialog(Window parent, String title) {
        this(parent, title, true);
    }

    public AbstractDialog(Window parent, String title, boolean modal) {
        super(parent, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.parent = parent;
    }

    public void center() {
        this.center(null);
    }

    public void center(Window parent) {
        JiveServices.center(parent, this);
    }

    public Window getParentWindow() {
        return this.parent;
    }

    public DialogAction getPerformedAction() {
        return this.performedAction;
    }

    public void setPerformedAction(DialogAction action) {
        this.performedAction = action;
    }

    public void setTimeout(int delay) {
        Timer timer = new Timer(delay, new ActionCloseDialog(this, "close-dialog"));
        timer.start();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.initialized) {
            this.init();
        }
        super.setVisible(visible);
    }

    protected void init() {
        this.initialized = true;
        JRootPane rootPane = this.getRootPane();
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put("cancel", new ActionCloseDialog(this, "cancel"));
        InputMap inputMap = rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        JiveFactory jive = JiveFactory.getInstance();
        this.res = jive.getResourceBundle();
        this.addWindowListener(new DialogListener());
    }

    protected TopPanel createTopPanel(String title) {
        TopPanel topPanel = new TopPanel();
        topPanel.setTitle(title);
        topPanel.setAlignment(Alignment.LEFT);
        topPanel.setBackground(this.getBackground());
        topPanel.setGradient(JiveConstants.COLOUR_BLUE_GRAY_1, JiveConstants.COLOUR_BLUE_GRAY_4);
        topPanel.setForeground(Color.white);
        topPanel.setTitle(title);
        return topPanel;
    }

    class DialogListener
    extends WindowAdapter {
        DialogListener() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            AbstractDialog.this.setPerformedAction(DialogAction.CANCEL);
            AbstractDialog.this.setVisible(false);
            AbstractDialog.this.dispose();
        }
    }
}

