/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.dialog.AbstractDialog;
import org.dbdoclet.jive.text.TextServices;
import org.dbdoclet.service.ResourceServices;

public class AboutDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JEditorPane editor;
    private ResourceBundle res;
    private JiveFactory wm = JiveFactory.getInstance();

    public AboutDialog(Frame frame, String title, URL resourceUrl, String type) throws IOException {
        this(frame, title, ResourceServices.readUrl(resourceUrl), type);
    }

    public AboutDialog(Frame frame, String title, String text, String type) throws IOException {
        super((Window)frame, title, true);
        this.res = this.wm.getResourceBundle();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        GridBagLayout layoutMgr = new GridBagLayout();
        JPanel textPanel = new JPanel(layoutMgr);
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)textPanel, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)buttonPanel, gridBagConstraints);
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setContentType(type);
        TextServices.setText(this.editor, text);
        JScrollPane editorScrollPane = new JScrollPane(this.editor);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setHorizontalScrollBarPolicy(32);
        editorScrollPane.setPreferredSize(new Dimension(550, 300));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        textPanel.add((Component)editorScrollPane, gridBagConstraints);
        JButton okButton = new JButton();
        buttonPanel.add(okButton);
        okButton.setText(ResourceServices.getString(this.res, "C_OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.center();
    }
}

