/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dbdoclet.jive.dialog.ExceptionBox;

public class ActionSetLookAndFeel
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ArrayList<Component> componentList;
    private UIManager.LookAndFeelInfo info;
    private String lnfClassName;

    public ActionSetLookAndFeel(String label, UIManager.LookAndFeelInfo info, ArrayList<Component> componentList) {
        super(label);
        if (componentList == null) {
            throw new IllegalArgumentException("The argument frame must not be null!");
        }
        this.componentList = componentList;
        this.info = info;
    }

    public ActionSetLookAndFeel(String label, String lnfClassName, ArrayList<Component> componentList) {
        super(label);
        if (componentList == null) {
            throw new IllegalArgumentException("The argument frame must not be null!");
        }
        this.componentList = componentList;
        this.lnfClassName = lnfClassName;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (this.info != null) {
                this.lnfClassName = this.info.getClassName();
            }
            if (this.lnfClassName != null) {
                UIManager.setLookAndFeel(this.lnfClassName);
                for (Component component : this.componentList) {
                    SwingUtilities.updateComponentTreeUI(component);
                    if (!(component instanceof Window)) continue;
                    ((Window)component).pack();
                }
            }
        }
        catch (Throwable oops) {
            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
        }
    }
}

