/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive;

import org.dbdoclet.unit.Length;

public class RegionFrame {
    private Length top;
    private Length right;
    private Length bottom;
    private Length left;

    public RegionFrame(Length top, Length right, Length bottom, Length left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public RegionFrame(int top, int right, int bottom, int left) {
        this.top = new Length(top);
        this.right = new Length(right);
        this.bottom = new Length(bottom);
        this.left = new Length(left);
    }

    public Length getTop() {
        return this.top;
    }

    public void setTop(Length top) {
        this.top = top;
    }

    public Length getRight() {
        return this.right;
    }

    public void setRight(Length right) {
        this.right = right;
    }

    public Length getBottom() {
        return this.bottom;
    }

    public void setBottom(Length bottom) {
        this.bottom = bottom;
    }

    public Length getLeft() {
        return this.left;
    }

    public void setLeft(Length left) {
        this.left = left;
    }

    public void scale(double ratio) {
        this.top.setLength((double)this.top.getLength() * ratio);
        this.bottom.setLength((double)this.bottom.getLength() * ratio);
        this.left.setLength((double)this.left.getLength() * ratio);
        this.right.setLength((double)this.right.getLength() * ratio);
    }

    public RegionFrame deepCopy() {
        RegionFrame copy = new RegionFrame(this.top.deepCopy(), this.right.deepCopy(), this.bottom.deepCopy(), this.left.deepCopy());
        return copy;
    }
}

