/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.service.StringServices;

public class JiveServices {
    public static void center(Window parent, Window wnd) {
        int ypos;
        int xpos;
        int width = wnd.getWidth();
        int height = wnd.getHeight();
        if (parent == null || !parent.isShowing()) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            xpos = (int)((dimension.getWidth() - (double)width) / 2.0);
            ypos = (int)((dimension.getHeight() - (double)height) / 2.0);
        } else {
            Dimension dimension = parent.getSize();
            Point point = parent.getLocationOnScreen();
            xpos = (int)((dimension.getWidth() - (double)width) / 2.0);
            ypos = (int)((dimension.getHeight() - (double)height) / 2.0);
            xpos += point.x;
            ypos += point.y;
        }
        wnd.setSize(width, height);
        wnd.setLocation(xpos, ypos);
    }

    public static void center(Window wnd) {
        JiveServices.center(null, wnd);
    }

    public static ImageIcon getJlfgrIcon(String iconUrl) {
        String buffer = StringServices.cutPrefix(iconUrl, "jlfgr:");
        String[] tokens = buffer.split("/");
        if (tokens != null && tokens.length == 2) {
            return JiveServices.getJlfgrIcon(tokens[0], tokens[1]);
        }
        throw new IllegalArgumentException("Invalid iconUrl '" + iconUrl + "'!");
    }

    public static ImageIcon getJlfgrIcon(String category, String name) {
        String path;
        if (category == null) {
            throw new IllegalArgumentException("The argument category must not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL iconUrl = loader.getResource(path = "/toolbarButtonGraphics/" + category + "/" + name);
        if (iconUrl == null) {
            iconUrl = JiveFactory.class.getResource(path);
        }
        if (iconUrl == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(iconUrl, path);
        return icon;
    }
}

