/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.jive;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveServices;
import org.dbdoclet.jive.action.ActionSetLookAndFeel;
import org.dbdoclet.jive.model.SpinnerDistanceModel;
import org.dbdoclet.jive.sheet.Sheet;
import org.dbdoclet.jive.sheet.SheetContainer;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.IdentifierTextField;
import org.dbdoclet.jive.widget.LanguageListBox;
import org.dbdoclet.jive.widget.MimeTypeListBox;
import org.dbdoclet.jive.widget.NumberTextField;
import org.dbdoclet.jive.widget.PathList;
import org.dbdoclet.jive.widget.RichLabel;
import org.dbdoclet.jive.widget.SpinnerDistanceEditor;
import org.dbdoclet.jive.widget.UpperCaseTextField;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.unit.Length;

public final class JiveFactory
implements ItemListener,
DocumentListener,
ActionListener,
ChangeListener {
    private static Log logger = LogFactory.getLog(JiveFactory.class);
    private static JiveFactory singleton;
    private ImageIcon applicationIcon;
    private URL backgroundImageUrl = null;
    private Font defaultFont = null;
    private Color defaultForeground;
    private Color helpAreaBackground = null;
    private Border helpAreaBorder = null;
    private HelpBroker helpBroker;
    private HelpSet helpSet;
    private final Locale locale;
    private ResourceBundle res = ResourceBundle.getBundle("org/dbdoclet/jive/Resources");
    private ArrayList<JComponent> saveWidgetList;
    private final HashMap<Identifier, JComponent> widgetMap;
    private Color defaultBackground;

    private JiveFactory(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("The argument locale must not be null!");
        }
        this.locale = locale;
        this.widgetMap = new HashMap();
        this.res = ResourceBundle.getBundle("org/dbdoclet/jive/Resources", locale);
    }

    public static Frame findParentFrame(JComponent comp) {
        if (comp == null) {
            return null;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    public static JiveFactory getInstance() {
        if (singleton == null) {
            singleton = JiveFactory.getInstance(Locale.getDefault());
        }
        return singleton;
    }

    public static JiveFactory getInstance(Locale locale) {
        System.setProperty("swing.aatext", "true");
        if (singleton != null) {
            logger.warn((Object)("Changing locale of global singleton WidgetMap to " + locale.toString()));
            singleton.setLocale(locale);
        } else {
            singleton = new JiveFactory(locale);
        }
        return singleton;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)("event=" + event));
        logger.debug((Object)("ActionEvent: \n  Source        = '" + event.getSource().getClass().getName() + "'\n" + "  ID            = '" + event.getID() + "'\n" + "  ActionCommand = '" + event.getActionCommand() + "'\n"));
    }

    public void addSaveWidget(JComponent widget) {
        if (this.saveWidgetList == null) {
            this.saveWidgetList = new ArrayList();
        }
        if (widget != null && !this.saveWidgetList.contains(widget)) {
            this.saveWidgetList.add(widget);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableSaveWidgets();
    }

    public JButton createButton(Identifier key, AbstractAction action) {
        JButton button = new JButton(action);
        this.addWidget(key, button);
        return button;
    }

    public JButton createButton(Identifier key, String text) {
        return this.createButton(key, text, null);
    }

    public JButton createButton(Identifier key, String text, String icon) {
        String location;
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        URL url = null;
        if (icon != null && icon.length() > 0 && (url = ClassLoader.getSystemResource(location = "toolbarButtonGraphics/" + icon + "24.gif")) == null) {
            url = this.getClass().getResource(location);
        }
        JButton button = url != null ? new JButton(text, new ImageIcon(url)) : new JButton(text);
        this.addWidget(key, button);
        return button;
    }

    public JButton createButton(String label) {
        return this.createButton(null, label);
    }

    public JCheckBox createCheckBox() {
        return this.createCheckBox(null, null);
    }

    public JCheckBox createCheckBox(Identifier key, String label) {
        JCheckBox checkBox = new JCheckBox(label);
        checkBox.addItemListener(this);
        this.addWidget(key, checkBox);
        return checkBox;
    }

    public JCheckBox createCheckBox(String label) {
        return this.createCheckBox(null, label);
    }

    public <T> JComboBox<T> createComboBox(Identifier key) {
        return this.createComboBox(key, null);
    }

    public <T> JComboBox<T> createComboBox(Identifier key, T[] list) {
        JComboBox<Object> comboBox = list == null ? new JComboBox() : new JComboBox<T>(list);
        comboBox.addItemListener(this);
        this.addWidget(key, comboBox);
        return comboBox;
    }

    public JSpinner createDistanceSpinner() {
        return this.createDistanceSpinner(null, null);
    }

    public JSpinner createDistanceSpinner(Identifier key) {
        return this.createDistanceSpinner(key, null, true);
    }

    public JSpinner createDistanceSpinner(Identifier key, boolean excludePercent) {
        return this.createDistanceSpinner(key, null, excludePercent);
    }

    public JSpinner createDistanceSpinner(Identifier key, Length distance) {
        return this.createDistanceSpinner(key, distance, true);
    }

    public JSpinner createDistanceSpinner(Identifier key, Length distance, boolean excludePercent) {
        SpinnerDistanceModel model = new SpinnerDistanceModel(this.getLocale());
        model.setExcludePercent(excludePercent);
        JSpinner spinner = new JSpinner(model);
        if (distance != null) {
            spinner.setValue(distance);
        }
        Dimension preferredSize = spinner.getPreferredSize();
        if (preferredSize.width < 100) {
            preferredSize.width = 100;
        }
        spinner.setPreferredSize(preferredSize);
        spinner.setEditor(new SpinnerDistanceEditor(spinner));
        spinner.addChangeListener(this);
        this.addWidget(key, spinner);
        return spinner;
    }

    public JSpinner createDistanceSpinner(Length length) {
        return this.createDistanceSpinner(null, length);
    }

    public JLabel createEntryHelp(String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        text = this.createToolTipText(text);
        JLabel label = new JLabel("Help24", JiveServices.getJlfgrIcon("general", "Help24.gif"), 0);
        label.setToolTipText(text);
        label.setForeground(new Color(0, 0, 205));
        return label;
    }

    public JTextComponent createErrorArea(Identifier key, JComponent parent) {
        return this.createErrorArea(key, parent, "<html>");
    }

    public JTextComponent createErrorArea(Identifier key, JComponent parent, String text) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent must not be null!");
        }
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JEditorPane errorArea = new JEditorPane();
        errorArea.setEditable(false);
        errorArea.setFocusable(false);
        errorArea.setBackground(Color.white);
        errorArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(139, 0, 0)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        if (text.toLowerCase().startsWith("<html>")) {
            errorArea.setContentType("text/html");
            Document doc = errorArea.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                StyleSheet styleSheet = htmlDoc.getStyleSheet();
                Font defaultFont = parent.getFont();
                String fontFamily = defaultFont.getFamily();
                int fontSize = defaultFont.getSize();
                styleSheet.addRule("body { color: #8b0000; font-family: " + fontFamily + ";" + " font-size: " + fontSize + ";" + "}");
                styleSheet.addRule("h1, h2 { font-family: " + fontFamily + ";" + " font-size: " + fontSize + ";" + " margin: 2px;" + "}");
                styleSheet.addRule("p { text-indent: 8px; margin: 2px;}");
                errorArea.setText(text);
            }
        } else {
            errorArea.setContentType("text/plain");
            errorArea.setText(text);
        }
        this.addWidget(key, errorArea);
        return errorArea;
    }

    public JTextComponent createErrorArea(JComponent parent, String text) {
        return this.createErrorArea(null, parent, text);
    }

    public JLabel createHeading(Identifier key, String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        String fontName = font.getName();
        int fontSize = (int)((double)font.getSize() * 1.6);
        Font headingFont = new Font(fontName, 1, fontSize);
        label.setFont(headingFont);
        label.setForeground(new Color(1, 48, 114));
        this.addWidget(key, label);
        return label;
    }

    public JTextComponent createHelpArea(Identifier key, JComponent parent) {
        return this.createHelpArea(key, parent, "<html>");
    }

    public JTextComponent createHelpArea(Identifier key, JComponent parent, String text) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent must not be null!");
        }
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JEditorPane helpArea = new JEditorPane();
        helpArea.setEditable(false);
        helpArea.setFocusable(false);
        if (this.helpAreaBackground == null) {
            helpArea.setBackground(parent.getBackground());
        } else {
            helpArea.setBackground(this.helpAreaBackground);
        }
        if (this.helpAreaBorder == null) {
            helpArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            helpArea.setBorder(this.helpAreaBorder);
        }
        if (text.toLowerCase().startsWith("<html>")) {
            helpArea.setContentType("text/html");
            Document doc = helpArea.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                StyleSheet styleSheet = htmlDoc.getStyleSheet();
                Font defaultFont = parent.getFont();
                String fontFamily = defaultFont.getFamily();
                int fontSize = defaultFont.getSize();
                styleSheet.addRule("body { font-family: " + fontFamily + ";" + " font-size: " + (fontSize - 2) + ";" + "}");
                styleSheet.addRule("h1, h2 { font-family: " + fontFamily + ";" + " font-size: " + (fontSize - 1) + ";" + " color: #031071;" + " margin: 2px;" + "}");
                styleSheet.addRule("p { margin: 2px;}");
                styleSheet.addRule("p.error { color: red;}");
                helpArea.setText(text);
            }
        } else {
            helpArea.setContentType("text/plain");
            helpArea.setText(text);
        }
        this.addWidget(key, helpArea);
        return helpArea;
    }

    public JTextComponent createHelpArea(JComponent parent) {
        return this.createHelpArea(null, parent, "<html>");
    }

    public JTextComponent createHelpArea(JComponent parent, String text) {
        return this.createHelpArea(null, parent, text);
    }

    public JEditorPane createHtmlArea(Identifier key, JComponent parent, String text) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent must not be null!");
        }
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JEditorPane htmlArea = new JEditorPane("text/html", text);
        htmlArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        htmlArea.setEditable(false);
        htmlArea.setMinimumSize(new Dimension(200, 100));
        this.addWidget(key, htmlArea);
        if (text.toLowerCase().startsWith("<html>")) {
            htmlArea.setContentType("text/html");
            Document doc = htmlArea.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                StyleSheet styleSheet = htmlDoc.getStyleSheet();
                Font defaultFont = parent.getFont();
                String fontFamily = defaultFont.getFamily();
                int fontSize = defaultFont.getSize();
                styleSheet.addRule("body { font-family: " + fontFamily + ";" + " font-size: " + fontSize + ";" + "}");
            }
        }
        return htmlArea;
    }

    public JButton createIconButton(Identifier key, ImageIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("The argument icon must not be null!");
        }
        JButton button = new JButton(icon);
        button.setActionCommand("icon-button");
        button.addActionListener(this);
        this.addWidget(key, button);
        return button;
    }

    public IdentifierTextField createIdentifierTextField(Identifier key, int width) {
        IdentifierTextField textfield = new IdentifierTextField(width);
        this.addWidget(key, textfield);
        return textfield;
    }

    public IdentifierTextField createIdentifierTextField(int width) {
        return this.createIdentifierTextField(null, width);
    }

    public JLabel createLabel(Identifier key, String text) {
        return this.createLabel(key, text, 1);
    }

    public JLabel createLabel(Identifier key, String text, int style) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        label.setFont(font.deriveFont(style));
        this.addWidget(key, label);
        return label;
    }

    public JLabel createLabel(String text) {
        return this.createLabel(null, text, 1);
    }

    public JLabel createLabel(String text, int style) {
        return this.createLabel(null, text, style);
    }

    public LanguageListBox createLanguageListBox(Identifier key, Locale locale) {
        LanguageListBox llb = new LanguageListBox(locale);
        this.addWidget(key, llb);
        return llb;
    }

    public <T> JList<T> createList(Identifier key) {
        JList list = new JList();
        this.addWidget(key, list);
        if (this.defaultBackground != null) {
            list.setBackground(this.defaultBackground.brighter());
        }
        return list;
    }

    public JMenu createLookAndFeelMenu(ArrayList<Component> componentList) {
        if (componentList == null) {
            throw new IllegalArgumentException("The argument frame must not be null!");
        }
        JMenu menu = new JMenu(ResourceServices.getString(this.res, "C_LOOK_AND_FEEL"));
        UIManager.LookAndFeelInfo[] infoList = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < infoList.length; ++i) {
            JMenuItem menuItem = new JMenuItem(infoList[i].getName());
            menuItem.setAction(new ActionSetLookAndFeel(infoList[i].getName(), infoList[i], componentList));
            menu.add(menuItem);
        }
        return menu;
    }

    public JMenu createMenu(Identifier key, String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JMenu menu = new JMenu(text);
        this.addWidget(key, menu);
        return menu;
    }

    public JMenu createMenu(String text) {
        return this.createMenu(null, text);
    }

    public JMenuItem createMenuItem(Identifier key, AbstractAction action) {
        JMenuItem menuItem = new JMenuItem(action);
        this.addWidget(key, menuItem);
        return menuItem;
    }

    public JMenuItem createMenuItem(Identifier key, String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        JMenuItem menuitem = new JMenuItem(text);
        this.addWidget(key, menuitem);
        return menuitem;
    }

    public MimeTypeListBox createMimeTypeListBox(Identifier key) {
        MimeTypeListBox mtlb = new MimeTypeListBox();
        this.addWidget(key, mtlb);
        return mtlb;
    }

    public JSpinner createNumberSpinner(Identifier key, int value, int min, int max, int step) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        this.addWidget(key, spinner);
        return spinner;
    }

    public NumberTextField createNumberTextField(Identifier key, int width) {
        NumberTextField textfield = new NumberTextField(width);
        textfield.getDocument().addDocumentListener(this);
        textfield.addActionListener(this);
        this.addWidget(key, textfield);
        return textfield;
    }

    public NumberTextField createNumberTextField(int width) {
        return this.createNumberTextField(null, width);
    }

    public JPanel createPanel(Identifier key) {
        return this.createPanel(key, null);
    }

    public JPanel createPanel(Identifier key, LayoutManager layoutManager) {
        JPanel panel = layoutManager != null ? new JPanel(layoutManager) : new JPanel();
        this.addWidget(key, panel);
        return panel;
    }

    public JPasswordField createPasswordField(Identifier key, int width) {
        JPasswordField passwordfield = new JPasswordField(width);
        passwordfield.setMinimumSize(passwordfield.getPreferredSize());
        this.addWidget(key, passwordfield);
        return passwordfield;
    }

    public PathList createPathList(Identifier key, int filterMask) {
        PathList pathlist = new PathList(this, filterMask);
        this.addWidget(key, pathlist);
        return pathlist;
    }

    public JRadioButton createRadioButton(Identifier key, ImageIcon icon) {
        JRadioButton button = new JRadioButton(icon);
        this.addWidget(key, button);
        return button;
    }

    public JRadioButton createRadioButton(Identifier key, String label) {
        JRadioButton button = new JRadioButton(label);
        this.addWidget(key, button);
        return button;
    }

    public RichLabel createRichLabel(String text) {
        RichLabel label = new RichLabel(text);
        this.addWidget(null, label);
        if (this.defaultForeground != null) {
            label.setForeground(this.defaultForeground);
        }
        if (this.defaultFont != null) {
            label.setFont(this.defaultFont.deriveFont(1));
        }
        return label;
    }

    public JScrollPane createScrollPane(Component client) {
        return this.createScrollPane(null, client);
    }

    public JScrollPane createScrollPane(Identifier key, Component client) {
        if (client == null) {
            throw new IllegalArgumentException("The argument client must not be null!");
        }
        JScrollPane scrollPane = new JScrollPane(client);
        this.addWidget(key, scrollPane);
        return scrollPane;
    }

    public Sheet createSheet(SheetContainer container) {
        return new Sheet(container, this.res);
    }

    public JSplitPane createSplitPane(Identifier key) {
        JSplitPane splitPane = new JSplitPane();
        this.addWidget(key, splitPane);
        return splitPane;
    }

    public JTabbedPane createTabbedPane() {
        return this.createTabbedPane(null);
    }

    public JTabbedPane createTabbedPane(Identifier key) {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addWidget(key, tabbedPane);
        return tabbedPane;
    }

    public JTable createTable(Identifier key) {
        JTable table = new JTable();
        this.addWidget(key, table);
        return table;
    }

    public JTextArea createTextArea(Identifier key) {
        JTextArea textarea = new JTextArea();
        textarea.getDocument().addDocumentListener(this);
        this.addWidget(key, textarea);
        return textarea;
    }

    public JTextArea createTextArea(Identifier key, int rows, int cols) {
        JTextArea textarea = new JTextArea(rows, cols);
        textarea.getDocument().addDocumentListener(this);
        this.addWidget(key, textarea);
        return textarea;
    }

    public JTextField createTextField(Identifier key, int width) {
        JTextField textfield = new JTextField(width);
        textfield.getDocument().addDocumentListener(this);
        textfield.addActionListener(this);
        textfield.setMinimumSize(textfield.getPreferredSize());
        this.addWidget(key, textfield);
        return textfield;
    }

    public JTextPane createTextPane() {
        return this.createTextPane(null);
    }

    public JTextPane createTextPane(Identifier key) {
        JTextPane textPane = new JTextPane();
        this.addWidget(key, textPane);
        return textPane;
    }

    public JToggleButton createToggleButton(Identifier key, String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument icon must not be null!");
        }
        JToggleButton button = new JToggleButton(text);
        button.setActionCommand("toggle-button");
        button.addActionListener(this);
        this.addWidget(key, button);
        return button;
    }

    public JToolBar createToolBar(Identifier key) {
        JToolBar toolbar = new JToolBar();
        this.addWidget(key, toolbar);
        return toolbar;
    }

    public String createToolTipText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("The argument text must not be null!");
        }
        text = text.trim();
        if (!(text = StringServices.splitAt(text, " ", 40, "<br>")).startsWith("<html>")) {
            text = "<html>" + text;
        }
        return text;
    }

    public JTree createTree(Identifier key) {
        return this.createTree(key, null);
    }

    public JTree createTree(Identifier key, TreeModel model) {
        JTree tree = model != null ? new JTree(model) : new JTree();
        this.addWidget(key, tree);
        return tree;
    }

    public UpperCaseTextField createUpperCaseTextField(Identifier key, int width) {
        UpperCaseTextField textfield = new UpperCaseTextField(width);
        this.addWidget(key, textfield);
        return textfield;
    }

    public JSpinner createWidthSpinner(Identifier key) {
        return this.createWidthSpinner(key, null);
    }

    public JSpinner createWidthSpinner(Identifier key, Length width) {
        JSpinner spinner = new JSpinner(new SpinnerDistanceModel(this.getLocale()));
        if (width != null) {
            spinner.setValue(width);
        }
        Dimension preferredSize = spinner.getPreferredSize();
        if (preferredSize.width < 75) {
            preferredSize.width = 75;
        }
        spinner.setPreferredSize(preferredSize);
        spinner.setEditor(new SpinnerDistanceEditor(spinner));
        spinner.addChangeListener(this);
        this.addWidget(key, spinner);
        return spinner;
    }

    public void disableAll(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Container parent = (Container)comp;
            Component[] compList = parent.getComponents();
            for (int i = 0; i < compList.length; ++i) {
                this.disableAll(compList[i]);
            }
        }
        if (comp instanceof AbstractButton || comp instanceof JComboBox || comp instanceof JTextComponent) {
            String name = comp.getName();
            if (name == null) {
                name = "";
            }
            logger.debug((Object)("disable name = " + name));
            if (comp.isEnabled()) {
                logger.debug((Object)("disabling name = " + name));
                comp.setEnabled(false);
                if (!name.endsWith("toggled")) {
                    comp.setName(name + ":toggled");
                }
            }
        }
    }

    public void disableSaveWidgets() {
        if (this.saveWidgetList != null && this.saveWidgetList.size() > 0) {
            for (JComponent comp : this.saveWidgetList) {
                comp.setEnabled(false);
            }
        }
    }

    public void enableAll(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Container parent = (Container)comp;
            Component[] compList = parent.getComponents();
            for (int i = 0; i < compList.length; ++i) {
                this.enableAll(compList[i]);
            }
        }
        if (comp instanceof AbstractButton || comp instanceof JComboBox || comp instanceof JTextComponent) {
            String name = comp.getName();
            if (name == null) {
                name = "";
            }
            logger.debug((Object)("enable name = " + name));
            if (!comp.isEnabled()) {
                if (name.endsWith(":toggled")) {
                    logger.debug((Object)("enabling name = " + name));
                    comp.setEnabled(true);
                } else {
                    comp.setName(name + ":enabled");
                }
            }
        }
    }

    public void enableSaveWidgets() {
        if (this.saveWidgetList != null && this.saveWidgetList.size() > 0) {
            for (JComponent comp : this.saveWidgetList) {
                comp.setEnabled(true);
            }
        }
    }

    public ImageIcon getApplicationIcon() {
        return this.applicationIcon;
    }

    public URL getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public Color getLabelForeground() {
        return this.defaultForeground;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getResourceBundle() {
        return this.res;
    }

    public JComponent getWidget(Identifier key) {
        return this.widgetMap.get(key);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableSaveWidgets();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableSaveWidgets();
    }

    public Font registerEuterpeFont() {
        try {
            InputStream instr = ResourceServices.getResourceAsStream("/fonts/Euterpe.ttf", JiveFactory.class.getClassLoader());
            if (instr != null) {
                Font font = Font.createFont(0, instr);
                return font;
            }
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableSaveWidgets();
    }

    public void setApplicationIcon(ImageIcon applicationIcon) {
        this.applicationIcon = applicationIcon;
    }

    public void setBackgroundImageUrl(URL backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public void setDefaultForeground(Color foreground) {
        this.defaultForeground = foreground;
    }

    public void setDefaultFont(Font defaultFont) {
        if (defaultFont == null) {
            throw new IllegalArgumentException("Parameter font must not be null!");
        }
        this.defaultFont = defaultFont;
    }

    public void setHelpAreaBackground(Color helpAreaBackground) {
        this.helpAreaBackground = helpAreaBackground;
    }

    public void setHelpAreaBorder(Border helpAreaBorder) {
        this.helpAreaBorder = helpAreaBorder;
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public void setHelpSet(HelpSet helpSet) {
        this.helpSet = helpSet;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("The argument locale must not be null!");
        }
        this.res = ResourceBundle.getBundle("org/dbdoclet/jive/Resources", locale);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableSaveWidgets();
    }

    private void addContextSensitiveHelp(Identifier key, JComponent comp) {
        if (this.helpBroker != null && this.helpSet != null) {
            try {
                CSH.setHelpIDString((Component)comp, (String)key.getValue());
                CSH.setHelpSet((Component)comp, (HelpSet)this.helpSet);
                this.helpBroker.enableHelpKey((Component)comp, key.getValue(), this.helpSet, "javax.help.Popup", "popup");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        comp.setName(key.getValue());
    }

    private void addWidget(Identifier key, JComponent comp) {
        if (this.defaultFont != null) {
            Font compFont = comp.getFont();
            comp.setFont(this.defaultFont.deriveFont(compFont.getStyle()));
        }
        if (this.defaultForeground != null) {
            comp.setForeground(this.defaultForeground);
        }
        if (this.defaultBackground != null) {
            comp.setBackground(this.defaultBackground);
        }
        if (key != null && key.length() > 0 && comp != null) {
            comp.setName(key.toString());
            this.addContextSensitiveHelp(key, comp);
            this.widgetMap.put(key, comp);
        }
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    public GridPanel createGridPanel(Identifier key) {
        GridPanel panel = new GridPanel();
        this.addWidget(key, panel);
        return panel;
    }
}

