/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.StringServices;

public class FileSet {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_INCLUDE_FILES = 1;
    public static final int FILTER_EXCLUDE_FILES = 2;
    public static final int FILTER_INCLUDE_DIRECTORIES = 3;
    public static final int FILTER_EXCLUDE_DIRECTORIES = 4;
    public static final int FILTER_INCLUDE_PACKAGES = 5;
    public static final int FILTER_EXCLUDE_PACKAGES = 6;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOT_FOUND = 1;
    public static final int STATUS_NOT_READABLE = 2;
    public static final int STATUS_DUPLICATE = 3;
    public static final int STATUS_VARIABLE = 4;
    private static Log logger = LogFactory.getLog(FileSet.class);
    private Integer id;
    private File cwd = null;
    private File path = null;
    private File canonicalPath = null;
    private Boolean caseSensitive = Boolean.TRUE;
    private int filterType = 0;
    private int status = 0;
    private String filter = "";

    public FileSet() throws IOException {
        this(new File("."), new File("."));
    }

    public FileSet(File cwd, File path) {
        if (cwd == null) {
            throw new IllegalArgumentException("The argument cwd may not be null!");
        }
        if (path == null) {
            throw new IllegalArgumentException("The argument path may not be null!");
        }
        this.cwd = cwd;
        this.caseSensitive = Boolean.TRUE;
        this.filterType = 0;
        this.filter = "";
        this.setPath(path);
    }

    public FileSet(File cwd, String path) {
        this(cwd, new File(path));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSet)) {
            return false;
        }
        FileSet comp = (FileSet)obj;
        return this.id == comp.getId();
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String getDirName() {
        if (this.path == null) {
            throw new IllegalStateException("The field path may not be null!");
        }
        String dirName = this.path.getPath();
        dirName = StringServices.replace(dirName, File.separator, "/");
        return dirName;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public Integer getId() {
        return this.id;
    }

    public String getPackageFilter() {
        String str = this.filter;
        if (str != null && str.length() > 0) {
            str = StringServices.replace(str, ".", "/");
        }
        return str;
    }

    public File getPath() {
        return this.path;
    }

    public File getRelativePath() {
        String relativePath;
        try {
            relativePath = FileServices.relativePath(this.cwd, this.getQualifiedPath());
        }
        catch (IOException e) {
            relativePath = this.path.getAbsolutePath();
        }
        return new File(relativePath);
    }

    public File getQualifiedPath() {
        return this.canonicalPath;
    }

    public int getStatus() {
        return this.status;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isDirectory() {
        return this.canonicalPath.isDirectory();
    }

    public boolean isDirectoryFilter() {
        return this.filterType == 3 || this.filterType == 4;
    }

    public boolean isFileFilter() {
        return this.filterType == 1 || this.filterType == 2;
    }

    public boolean isPackageFilter() {
        return this.filterType == 0 || this.filterType == 5 || this.filterType == 6;
    }

    public boolean isVariable() {
        int status = this.getStatus();
        return status == 4;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = new Boolean(caseSensitive);
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public void setId(int id) {
        this.id = new Integer(id);
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPath(File file) {
        this.path = file;
        this.canonicalPath = file;
        String strPath = file.getPath();
        if (strPath.matches("^.*\\$\\{\\p{Graph}+\\}.*$")) {
            this.status = 4;
            return;
        }
        if (!FileServices.isAbsolutePath(strPath = FileServices.normalizePath(strPath))) {
            strPath = strPath.endsWith("/") ? FileServices.appendPath(this.cwd, strPath) : FileServices.appendFileName(this.cwd, strPath);
        }
        logger.debug((Object)("path = " + strPath));
        this.canonicalPath = new File(strPath);
        this.status = 0;
        if (!this.canonicalPath.canRead()) {
            this.status = 2;
        }
        if (!this.canonicalPath.exists()) {
            logger.error((Object)String.format("Path %s not found!", this.canonicalPath.getAbsolutePath()));
            this.status = 1;
        }
        try {
            this.canonicalPath = this.canonicalPath.getCanonicalFile();
        }
        catch (IOException oops) {
            oops.printStackTrace();
        }
    }

    public void setPath(File cwd, File path) {
        if (cwd == null) {
            throw new IllegalArgumentException("The argument cwd may not be null!");
        }
        if (path == null) {
            throw new IllegalArgumentException("The argument path may not be null!");
        }
        this.cwd = cwd;
        this.setPath(path);
    }

    public String toString() {
        String str = this.path.getPath() + "[cwd=" + this.cwd.getAbsolutePath() + ",filterType=" + this.filterType + "]";
        return str;
    }
}

