/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressVetoListener;
import org.dbdoclet.service.FileServices;

public class Eraser {
    private static Log logger = LogFactory.getLog(Eraser.class);
    private ArrayList<ProgressVetoListener> progressListenerList = new ArrayList();
    private LinkedHashMap<File, File> jobList = new LinkedHashMap();

    public int getJobCount() {
        return this.jobList.size();
    }

    public void doDelete() throws IOException {
        Iterator<File> iterator = this.jobList.keySet().iterator();
        int index = 1;
        while (iterator.hasNext()) {
            File file = iterator.next();
            this.fireProgressEvent(new ProgressEvent(index, "File", file.getAbsolutePath()));
            FileServices.delete(file);
            ++index;
        }
    }

    public void add(String path) throws IOException {
        this.add(new File(path));
    }

    public void add(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isFile()) {
            this.addToJobList(file);
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                logger.debug((Object)("files[" + i + "]=" + files[i]));
                FileServices.setWritable(files[i]);
                if (files[i].isDirectory()) {
                    FileServices.setWritable(file);
                    this.add(files[i]);
                }
                if (!files[i].isFile()) continue;
                this.addToJobList(files[i]);
            }
            this.addToJobList(file);
        }
    }

    public void addProgressListener(ArrayList<ProgressVetoListener> list) {
        if (list != null) {
            this.progressListenerList.addAll(list);
        }
    }

    public void addProgressListener(ProgressVetoListener progressListener) {
        if (!this.progressListenerList.contains(progressListener)) {
            this.progressListenerList.add(progressListener);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListenerList.remove(progressListener);
    }

    private void fireProgressEvent(ProgressEvent event) {
        if (this.progressListenerList == null || this.progressListenerList.size() == 0) {
            return;
        }
        for (ProgressListener progressListener : this.progressListenerList) {
            progressListener.progress(event);
        }
    }

    private void addToJobList(File file) {
        this.fireProgressEvent(new ProgressEvent().setStage(1).setUserObject(file));
        File job = this.jobList.get(file);
        if (job != null) {
            logger.warn((Object)("File " + job + " is overriden by file " + file));
        }
        this.jobList.put(file, file);
    }
}

