/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.io.CopyJob;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.service.FileServices;

public class Copier {
    private static Log logger = LogFactory.getLog(Copier.class);
    private ArrayList<ProgressListener> progressListenerList = new ArrayList();
    private LinkedHashMap<File, CopyJob> jobList = new LinkedHashMap();

    public int getJobCount() {
        return this.jobList.size();
    }

    public Set<File> getJobList() {
        return this.jobList.keySet();
    }

    public void doCopy() throws IOException {
        this.doCopy(null);
    }

    public void doCopy(Map<String, String> filterSet) throws IOException {
        for (File dest : this.jobList.keySet()) {
            CopyJob job = this.jobList.get(dest);
            if (filterSet == null) {
                FileServices.copyFileToFile(job.getFrom(), job.getTo());
                continue;
            }
            FileServices.copyFileToFile(job.getFrom(), job.getTo(), filterSet);
        }
    }

    public void add(String src, String dest) throws IOException {
        this.add(new File(src), new File(dest));
    }

    public void add(File src, File dest) throws IOException {
        logger.debug((Object)("src=" + src + ", dest=" + dest));
        if (src == null) {
            throw new IllegalArgumentException("The argument src must not be null!");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The argument dest must not be null!");
        }
        if (!src.exists()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new IllegalArgumentException("Can't copy a directory (" + src.getAbsolutePath() + " to a file (" + dest.getAbsolutePath() + ")!");
        }
        if (src.isFile() && (!dest.exists() || dest.isFile())) {
            this.addToJobList(dest, src);
            return;
        }
        if (src.isFile() && dest.isDirectory()) {
            String path = FileServices.appendFileName(dest, src.getName());
            this.addToJobList(new File(path), src);
            return;
        }
        if (src.isDirectory() && !dest.exists()) {
            FileServices.createPath(dest);
        }
        if (src.isDirectory() && dest.isDirectory()) {
            File[] files = src.listFiles();
            for (int i = 0; i < files.length; ++i) {
                logger.debug((Object)("files[" + i + "]=" + files[i]));
                String destFileName = FileServices.appendFileName(dest, files[i].getName());
                File destFile = new File(destFileName);
                if (files[i].isDirectory()) {
                    FileServices.createPath(destFile);
                    this.add(files[i], destFile);
                }
                if (!files[i].isFile()) continue;
                this.addToJobList(destFile, files[i]);
            }
        }
    }

    public void addProgressListener(ArrayList<ProgressListener> list) {
        if (list != null) {
            this.progressListenerList.addAll(list);
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (progressListener != null && !this.progressListenerList.contains(progressListener)) {
            this.progressListenerList.add(progressListener);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListenerList.remove(progressListener);
    }

    private void fireProgressEvent(ProgressEvent event) {
        if (this.progressListenerList == null || this.progressListenerList.size() == 0) {
            return;
        }
        for (ProgressListener listener : this.progressListenerList) {
            listener.progress(event);
        }
    }

    private void addToJobList(File dest, File src) {
        this.fireProgressEvent(new ProgressEvent().setStage(1).setUserObject(dest));
        CopyJob job = this.jobList.get(dest);
        if (job != null) {
            logger.debug((Object)("File " + job.getFrom() + " is overriden by file " + src));
        }
        this.jobList.put(dest, new CopyJob(src, dest));
    }
}

