/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.html.tokenizer.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.html.tokenizer.parser.HtmlTokenizerConstants;
import org.dbdoclet.html.tokenizer.parser.HtmlTokenizerTokenManager;
import org.dbdoclet.html.tokenizer.parser.HtmlTokenizerTreeConstants;
import org.dbdoclet.html.tokenizer.parser.JJTHtmlTokenizerState;
import org.dbdoclet.html.tokenizer.parser.Node;
import org.dbdoclet.html.tokenizer.parser.ParseException;
import org.dbdoclet.html.tokenizer.parser.SimpleCharStream;
import org.dbdoclet.html.tokenizer.parser.SimpleNode;
import org.dbdoclet.html.tokenizer.parser.Token;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;

public class HtmlTokenizer
implements HtmlTokenizerTreeConstants,
HtmlTokenizerConstants {
    protected JJTHtmlTokenizerState jjtree = new JJTHtmlTokenizerState();
    private static Log logger = LogFactory.getLog(HtmlTokenizer.class);
    private ArrayList<org.dbdoclet.html.tokenizer.Token> tokenList;
    private ArrayList<ProgressListener> listeners;
    public HtmlTokenizerTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public HtmlTokenizer(String buffer, String encoding) throws UnsupportedEncodingException {
        this(new ByteArrayInputStream(buffer.getBytes(encoding)), encoding);
    }

    public synchronized ArrayList<org.dbdoclet.html.tokenizer.Token> parse() throws ParseException {
        this.tokenList = new ArrayList();
        this.start();
        return this.tokenList;
    }

    public final void start() throws ParseException {
        block19: {
            SimpleNode jjtn000 = new SimpleNode(0);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            try {
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 22: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block19;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            this.tag();
                            continue block13;
                        }
                        case 9: 
                        case 10: {
                            this.text();
                            continue block13;
                        }
                        case 22: {
                            this.comment();
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                }
            }
        }
    }

    public final void tag() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(1);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token tag = null;
        Token name = null;
        Token value = null;
        Token slash1 = null;
        Token slash2 = null;
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        try {
            CharSequence buffer;
            org.dbdoclet.html.tokenizer.Token token = new org.dbdoclet.html.tokenizer.Token();
            this.tokenList.add(token);
            this.fireProgressEvent(token.toString());
            try {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        slash1 = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                tag = this.ncname();
                token.setTagName(tag.image);
                token.setLine(tag.beginLine);
                token.setColumn(tag.beginColumn);
                this.trace("Tag: " + tag.image);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block20;
                        }
                    }
                    name = this.attrName();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: {
                            this.equals();
                            value = this.attrValue();
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                        }
                    }
                    if (value == null || (buffer = value.image) == null) continue;
                    if (((String)buffer).startsWith("\"") || ((String)buffer).startsWith("'")) {
                        buffer = ((String)buffer).substring(1, ((String)buffer).length());
                    }
                    if (((String)buffer).endsWith("\"") || ((String)buffer).endsWith("'")) {
                        buffer = ((String)buffer).substring(0, ((String)buffer).length() - 1);
                    }
                    attributeMap.put(name.image, (String)buffer);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        slash2 = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                this.jj_consume_token(16);
            }
            catch (Throwable oops) {
                logger.warn((Object)String.format("Invalid attributes in Element %s line %d column %d", token.getTagName(), token.getLine(), token.getColumn()));
                logger.warn((Object)oops.getMessage());
                Token t = this.skipTo(0, 0, token.toString(), 16, 8);
                token.setValue("&lt;" + token.getTagName() + this.toAttributesAsText(attributeMap) + t.image);
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                }
                return;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append('<');
            if (slash1 != null) {
                ((StringBuilder)buffer).append('/');
            }
            if (tag != null) {
                ((StringBuilder)buffer).append(tag.image);
            }
            ((StringBuilder)buffer).append(this.toAttributesAsText(attributeMap));
            if (slash2 != null) {
                ((StringBuilder)buffer).append('/');
            }
            ((StringBuilder)buffer).append('>');
            this.trace(((StringBuilder)buffer).toString());
            token.setValue(((StringBuilder)buffer).toString());
            token.setAttributes(attributeMap);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void comment() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token comment = this.jj_consume_token(22);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            org.dbdoclet.html.tokenizer.Token token = new org.dbdoclet.html.tokenizer.Token(comment.image);
            this.tokenList.add(token);
            this.fireProgressEvent(token.toString());
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void text() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token text;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    text = this.jj_consume_token(10);
                    break;
                }
                case 9: {
                    text = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            org.dbdoclet.html.tokenizer.Token token = new org.dbdoclet.html.tokenizer.Token(text.image);
            this.trace("text() " + token);
            this.tokenList.add(token);
            this.fireProgressEvent(token.toString());
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token ncname() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(19);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t;
            return token;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void equals() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jj_consume_token(17);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token attrName() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(6);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token token = null;
        try {
            Token token2 = token = this.jj_consume_token(19);
            return token2;
        }
        catch (Throwable oops) {
            logger.warn((Object)String.format("Invalid attributes in Element %s line %d column %d", token.image, token.beginLine, token.beginColumn));
            logger.warn((Object)oops.getMessage());
            Token token3 = this.skipTo(0, 2, "", 16, 9);
            return token3;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token attrValue() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(7);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token token = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    token = this.jj_consume_token(20);
                    break;
                }
                case 19: {
                    token = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Token token2 = token;
            return token2;
        }
        catch (Throwable oops) {
            logger.warn((Object)String.format("Invalid attributes in Element %s line %d column %d", token.image, token.beginLine, token.beginColumn));
            logger.warn((Object)oops.getMessage());
            Token token3 = this.skipTo(0, 2, "", 16, 9);
            return token3;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token skipTo(int preContext, int postContext, String prev, int ... kind) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            StringBuilder buffer = new StringBuilder();
            boolean skip = true;
            this.token_source.SwitchTo(preContext);
            while (skip) {
                Token t = this.getNextToken();
                buffer.append(t.image);
                if (t.kind == 0) break;
                for (int stop : kind) {
                    if (t.kind != stop) continue;
                    skip = false;
                }
            }
            this.token_source.SwitchTo(postContext);
            Token token = new Token(20, buffer.toString());
            return token;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toAttributesAsText(HashMap<String, String> attributeMap) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            StringBuilder buffer = new StringBuilder();
            for (String attr : attributeMap.keySet()) {
                buffer.append(' ');
                buffer.append(attr);
                buffer.append("=\"");
                buffer.append(attributeMap.get(attr));
                buffer.append("\"");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressListeners(ArrayList<ProgressListener> listeners) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(10);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.listeners = listeners;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProgressEvent(String action) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(11);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            if (this.listeners != null) {
                ProgressEvent event = new ProgressEvent("Tokenizer: " + action);
                event.setStage(1);
                ProgressManager pm = new ProgressManager(this.listeners);
                pm.fireProgressEvent(event);
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    private void trace(String text) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(12);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        if (jjtc000) {
            this.jjtree.closeNodeScope((Node)jjtn000, true);
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x400700, 0x400700, 262144, 524288, 131072, 262144, 1536, 0x180000};
    }

    public HtmlTokenizer(InputStream stream) {
        this(stream, null);
    }

    public HtmlTokenizer(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new HtmlTokenizerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public HtmlTokenizer(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HtmlTokenizerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public HtmlTokenizer(HtmlTokenizerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(HtmlTokenizerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[30];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 30; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        HtmlTokenizer.jj_la1_init_0();
    }
}

