/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.html.tokenizer;

import java.text.ParseException;
import java.util.ArrayList;
import org.dbdoclet.html.tokenizer.Token;
import org.dbdoclet.html.tokenizer.TokenizerException;
import org.dbdoclet.html.tokenizer.parser.HtmlTokenizer;
import org.dbdoclet.html.tokenizer.parser.TokenMgrError;
import org.dbdoclet.progress.ProgressListener;

public class Tokenizer {
    private ArrayList<Token> tokens;
    private Token currentToken;
    private StringBuffer buffer = null;
    private int tokenPosition = 0;
    private ArrayList<ProgressListener> listeners;

    public Tokenizer(String data) {
        this.buffer = new StringBuffer(data);
    }

    public void tokenize() throws TokenizerException {
        this.tokenPosition = 0;
        this.tokens = this.parse();
    }

    public boolean hasNext() {
        return this.tokenPosition < this.tokens.size();
    }

    public Token next() {
        if (this.tokenPosition >= this.tokens.size()) {
            return null;
        }
        this.currentToken = this.tokens.get(this.tokenPosition);
        ++this.tokenPosition;
        return this.currentToken;
    }

    public int size() {
        if (this.tokens == null) {
            throw new IllegalStateException("Variable tokens is null!");
        }
        return this.tokens.size();
    }

    public int position() {
        return this.tokenPosition;
    }

    private ArrayList<Token> parse() throws TokenizerException {
        try {
            HtmlTokenizer parser = new HtmlTokenizer(this.buffer.toString(), "UTF-8");
            parser.setProgressListeners(this.listeners);
            return parser.parse();
        }
        catch (Throwable oops) {
            String msg = "Tokenizer Error";
            if (oops instanceof TokenMgrError || oops instanceof ParseException) {
                msg = "Parse error " + oops.getMessage() + " while parsing \"" + this.buffer.toString() + "\".";
            }
            throw new TokenizerException(msg, oops);
        }
    }

    public void setProgressListeners(ArrayList<ProgressListener> listeners) {
        this.listeners = listeners;
    }
}

