/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.html.tokenizer;

import java.util.HashMap;
import org.dbdoclet.service.StringServices;

public class Token {
    private String value;
    private String tagName;
    private HashMap<String, String> tagAttributes;
    private String type;
    private int line;
    private int column;

    public Token() {
        this("");
    }

    public Token(String token) {
        if (token == null) {
            throw new IllegalArgumentException("The argument token may not be null!");
        }
        this.type = "__UNKNOWN__";
        this.tagAttributes = new HashMap();
        this.value = this.parse(token);
    }

    public String getAttribute(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("The argument attrName must not be null!");
        }
        if (this.tagAttributes != null) {
            return this.tagAttributes.get(attrName);
        }
        return null;
    }

    public HashMap<String, String> getAttributes() {
        return this.tagAttributes;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getValue() {
        if (this.isComment() && this.value != null) {
            String buffer = this.value.trim();
            buffer = StringServices.cutPrefix(buffer, "<!--");
            buffer = StringServices.cutSuffix(buffer, "-->");
            buffer = buffer.trim();
            return buffer;
        }
        return this.value;
    }

    public boolean isClosingTag() {
        return this.type.endsWith(".Closing") || this.type.endsWith(".Empty");
    }

    public boolean isComment() {
        return this.type.equals("Text.Comment");
    }

    public boolean isDoctype() {
        return this.type.equals("Doctype");
    }

    public boolean isEmptyTag() {
        return this.type.equals("Tag.Empty");
    }

    public boolean isJavadoc() {
        return this.type.startsWith("Tag.Javadoc.");
    }

    public boolean isOpeningTag() {
        return this.type.endsWith(".Opening") || this.type.endsWith(".Empty");
    }

    public boolean isTag() {
        return this.type.startsWith("Tag.");
    }

    public boolean isText() {
        return this.type.startsWith("Text.");
    }

    public boolean isWhitespace() {
        return this.type.equals("Text.Whitespace");
    }

    public void setAttributes(HashMap<String, String> attributes) {
        this.tagAttributes = attributes;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setTagName(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter tagName is null!");
        }
        this.tagName = tagName;
    }

    public void setValue(String value) {
        this.value = value;
        this.parse(value);
    }

    public void appendValue(String value) {
        this.value = this.value + value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.tagName != null) {
            buffer.append(this.tagName);
            buffer.append(", ");
        }
        if (this.type != null) {
            buffer.append(this.type);
            buffer.append(", ");
        }
        if (this.value != null) {
            buffer.append(this.value);
        }
        if (buffer.length() > 42) {
            buffer.delete(39, buffer.length());
            buffer.append("...");
        }
        return buffer.toString();
    }

    private String parse(String token) {
        if (token == null) {
            return null;
        }
        String value = token.trim();
        this.type = value.startsWith("<!--") && value.endsWith("-->") ? "Text.Comment" : (value.startsWith("<!") && value.endsWith(">") ? "Doctype" : (value.startsWith("<?") && value.endsWith("?>") ? "Declaration" : (value.startsWith("<") && value.endsWith("/>") ? "Tag.Empty" : (value.startsWith("<javadoc:") && value.endsWith(">") ? "Tag.Javadoc.Opening" : (value.startsWith("</javadoc:") && value.endsWith(">") ? "Tag.Javadoc.Closing" : (value.startsWith("</") && value.endsWith(">") ? "Tag.Closing" : (value.startsWith("<") && value.endsWith(">") ? "Tag.Opening" : (value.trim().equals("") ? "Text.Whitespace" : "Text."))))))));
        return token;
    }
}

