/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.html.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.html.parser.ParserException;
import org.dbdoclet.html.tokenizer.Token;
import org.dbdoclet.html.tokenizer.Tokenizer;
import org.dbdoclet.html.tokenizer.TokenizerException;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ReplaceServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.html.A;
import org.dbdoclet.tag.html.Body;
import org.dbdoclet.tag.html.Frameset;
import org.dbdoclet.tag.html.Head;
import org.dbdoclet.tag.html.HeadingElement;
import org.dbdoclet.tag.html.Html;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.tag.html.Li;
import org.dbdoclet.tag.html.P;
import org.dbdoclet.tag.html.Pre;
import org.dbdoclet.tag.html.Title;
import org.dbdoclet.xiphias.HtmlServices;
import org.dbdoclet.xiphias.dom.CommentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;
import org.dbdoclet.xiphias.dom.NodeStack;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlParser {
    private static final String HTML = "html";
    public static final int CONTEXT_HTML = 1;
    public static final int CONTEXT_BODY = 2;
    private static Log logger = LogFactory.getLog(HtmlParser.class);
    private int treeSize = 0;
    private final ArrayList<ProgressListener> listeners = new ArrayList();
    private final HashMap<String, String> unsupportedTags = new HashMap();
    private final NodeStack openTags = new NodeStack();
    private final NodeStack openElements = new NodeStack();
    private int codeContext = 1;
    private final String title = "";

    public static int computeSize(Node node) {
        NodeList childNodes = node.getChildNodes();
        int elemCounter = 1;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            elemCounter += HtmlParser.computeSize(child);
        }
        return elemCounter;
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Parameter listener is null!");
        }
        this.listeners.add(listener);
    }

    public String getTitle() {
        return "";
    }

    public int getTreeSize() {
        return this.treeSize;
    }

    public HtmlDocument parseDocument(File file) throws IOException, ParserException, TokenizerException {
        String htmlCode = FileServices.readToString(file);
        return this.parseDocument(htmlCode);
    }

    public HtmlDocument parseDocument(String htmlCode) throws ParserException, TokenizerException {
        HtmlDocument doc = new HtmlDocument();
        if (this.parseInternal(htmlCode, doc, null)) {
            return doc;
        }
        doc = new HtmlDocument();
        this.setCodeContext(2);
        this.parseInternal(htmlCode, doc, null);
        return doc;
    }

    public HtmlFragment parseFragment(String htmlCode) throws ParserException, TokenizerException {
        HtmlFragment fragment = new HtmlFragment();
        this.setCodeContext(2);
        this.parseInternal(htmlCode, fragment, null);
        return fragment;
    }

    public HtmlFragment parseFragment(String htmlCode, String skipTo) throws ParserException, TokenizerException {
        HtmlFragment fragment = new HtmlFragment();
        this.setCodeContext(2);
        this.parseInternal(htmlCode, fragment, skipTo);
        return fragment;
    }

    public void postparse(NodeImpl root, NodeImpl node) {
        NodeListImpl childNodes = node.getTrafoChildNodes();
        for (NodeImpl child : new ArrayList<NodeImpl>(childNodes)) {
            NodeImpl parent = child.getTrafoParentNode();
            if (parent != null && child instanceof HeadingElement && parent instanceof A) {
                child.swapWithParent();
            }
            if (child.getNodeType() != 1) continue;
            this.postparse(root, child);
        }
    }

    public void setCodeContext(int context) {
        switch (context) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid code context '" + context + "'.");
            }
        }
        this.codeContext = context;
    }

    public boolean isFragment(String htmlCode) throws TokenizerException {
        if (htmlCode == null) {
            throw new IllegalArgumentException("The argument htmlCode must not be null!");
        }
        Tokenizer tokenizer = new Tokenizer(htmlCode);
        tokenizer.tokenize();
        Token token = null;
        while (tokenizer.hasNext()) {
            token = tokenizer.next();
            if (!token.isTag()) continue;
            return !HTML.equalsIgnoreCase(token.getTagName());
        }
        return true;
    }

    private void addOpenTag(NodeImpl elem) {
        String tag = elem.getNodeName();
        this.openElements.push(elem);
        this.openTags.push(tag.toLowerCase());
    }

    private String capFirstLetter(String s) {
        if (s != null && s.length() > 0) {
            s = s.toLowerCase();
            StringBuffer b = new StringBuffer(s);
            b.setCharAt(0, Character.toUpperCase(b.charAt(0)));
            return b.toString();
        }
        return s;
    }

    private boolean checkCodeContext(NodeImpl candidate) {
        return this.codeContext != 2 || !(candidate instanceof Head) && !(candidate instanceof Title) && !(candidate instanceof Html) && !(candidate instanceof Frameset);
    }

    private int closeClosingTag(String tag, NodeImpl currentNode) {
        if (currentNode == null || !(currentNode instanceof HtmlElement)) {
            return 0;
        }
        Node elem = currentNode;
        String tagName = elem.getNodeName();
        if (tagName == null) {
            return 0;
        }
        while (elem != null && !elem.getNodeName().equalsIgnoreCase(tag)) {
            elem = elem.getParentNode();
        }
        if (elem == null) {
            logger.debug((Object)("Tag <" + tag + "> has no corresponding opening tag!"));
            return 0;
        }
        int nesting = 0;
        int depth = this.openTags.search(tag);
        logger.debug((Object)("Open tag stack = '" + this.openTags + "'"));
        for (int i = 0; i < depth; ++i) {
            this.removeOpenTag();
            ++nesting;
        }
        return nesting;
    }

    private int closeOpenTag(String tag, NodeImpl currentNode) {
        int dtDepth;
        int liDepth;
        int trDepth;
        int depth;
        int tdDepth;
        String search = "";
        logger.debug((Object)("Testing tag \"" + tag + "\". The current node is " + currentNode + "."));
        if ((tag.equalsIgnoreCase("address") || tag.equalsIgnoreCase("div") || tag.equalsIgnoreCase("dl") || tag.equalsIgnoreCase("menu") || tag.equalsIgnoreCase("ol") || tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("pre") || tag.equalsIgnoreCase("table") || tag.equalsIgnoreCase("ul")) && this.openTags.search("p") != -1) {
            search = "p";
        }
        if (tag.equalsIgnoreCase("h1") || tag.equalsIgnoreCase("h2") || tag.equalsIgnoreCase("h3") || tag.equalsIgnoreCase("h4") || tag.equalsIgnoreCase("h5") || tag.equalsIgnoreCase("h6")) {
            search = "p";
        }
        if (tag.equalsIgnoreCase("td") && (tdDepth = this.openTags.search("td")) != -1 && (depth = this.openTags.search("tr")) != -1 && depth > tdDepth) {
            search = "td";
        }
        if (tag.equalsIgnoreCase("tr") && (trDepth = this.openTags.search("tr")) != -1 && (depth = this.openTags.search("table")) != -1 && depth > trDepth) {
            search = "tr";
        }
        if (tag.equalsIgnoreCase("li") && (liDepth = this.openTags.search("li")) != -1) {
            int uldepth = this.openTags.search("ul");
            int oldepth = this.openTags.search("ol");
            int depth2 = -1;
            if (oldepth == -1 && uldepth != -1) {
                depth2 = uldepth;
            }
            if (oldepth != -1 && uldepth == -1) {
                depth2 = oldepth;
            }
            if (oldepth != -1 && uldepth != -1 && oldepth < uldepth) {
                depth2 = oldepth;
            }
            if (oldepth != -1 && uldepth != -1 && uldepth < oldepth) {
                depth2 = uldepth;
            }
            if (depth2 != -1 && depth2 > liDepth) {
                search = "li";
            }
            if (depth2 != -1 && depth2 > liDepth) {
                search = "li";
            }
        }
        if (tag.equalsIgnoreCase("dd") && (dtDepth = this.openTags.search("dt")) != -1) {
            search = "dt";
        }
        if (tag.equalsIgnoreCase("dt")) {
            int dddepth = this.openTags.search("dd");
            int dldepth = this.openTags.search("dl");
            if (dddepth != -1 && dldepth > dddepth) {
                search = "dd";
            }
            if (dddepth != -1 && dldepth != -1 && dldepth < dddepth) {
                search = "";
            }
        }
        int depth3 = this.openTags.search(search);
        return depth3;
    }

    private HtmlElement createElement(Token token, NodeImpl parent) {
        String className;
        HtmlElement node = null;
        String tagName = token.getTagName().toLowerCase();
        logger.debug((Object)("tagName=" + tagName));
        if (token.isJavadoc()) {
            tagName = tagName.substring("javadoc:".length());
            className = "org.dbdoclet.tag.javadoc." + this.capFirstLetter(tagName);
            logger.debug((Object)("Javadoc classname = '" + className + "'."));
        } else {
            className = "org.dbdoclet.tag.html." + this.capFirstLetter(tagName);
        }
        try {
            Class<?> tagClass = Class.forName(className);
            node = (HtmlElement)tagClass.newInstance();
            node.setParentNode(parent);
            node.setTrafoStringAttributes(token.getAttributes());
            node.setLine(token.getLine());
            node.setColumn(token.getColumn());
        }
        catch (ClassNotFoundException oops) {
            if (this.unsupportedTags.get(tagName) == null) {
                logger.debug((Object)("Tag " + tagName + " is not supported! (" + className + ")"));
                this.unsupportedTags.put(tagName, className);
            }
        }
        catch (Exception oops) {
            logger.error((Object)("Exception: " + oops.getClass().getName() + " " + oops.getMessage()));
        }
        return node;
    }

    private boolean parseInternal(String htmlCode, NodeImpl root, String skipTo) throws ParserException, TokenizerException {
        ProgressManager pm = new ProgressManager(this.listeners);
        this.treeSize = 1;
        String errorBuffer = "";
        boolean firstElement = true;
        boolean rc = true;
        boolean index = false;
        int nesting = 0;
        if (htmlCode == null || htmlCode.equals("")) {
            return false;
        }
        boolean skip = false;
        if (skipTo != null) {
            skip = true;
        }
        Tokenizer tokenizer = new Tokenizer(htmlCode);
        tokenizer.setProgressListeners(this.listeners);
        tokenizer.tokenize();
        Token token = null;
        NodeImpl currentNode = root;
        HtmlElement candidate = null;
        String title = "";
        while (tokenizer.hasNext()) {
            String tagName;
            token = tokenizer.next();
            ProgressEvent event = new ProgressEvent(tokenizer.size(), tokenizer.position());
            event.setAction("HTML Parser: " + token.toString());
            event.setStage(1);
            pm.fireProgressEvent(event);
            logger.debug((Object)String.format("++++++ PROCESSING NEXT TOKEN %s", token.getTagName()));
            logger.debug((Object)("token=" + token.toString()));
            logger.debug((Object)("currentNode=" + currentNode));
            if (token.isDoctype() && currentNode == root) continue;
            if (this.codeContext == 1 && firstElement) {
                tagName = token.getTagName();
                if (tagName != null) {
                    tagName = tagName.toLowerCase();
                }
                if (tagName != null && tagName.equals(HTML)) {
                    firstElement = false;
                } else if (tagName != null && tagName.equals("body")) {
                    logger.debug((Object)"Missing html tag.");
                    firstElement = false;
                } else {
                    if (!token.isTag()) continue;
                    logger.debug((Object)("Found tag before html tag: " + token.toString()));
                    if (errorBuffer.length() < 16832) {
                        errorBuffer = errorBuffer + "Found tag before html tag:  " + token.toString() + ".\n";
                    } else if (!errorBuffer.endsWith("More...\n")) {
                        errorBuffer = errorBuffer + "More...\n";
                    }
                    rc = false;
                    continue;
                }
            }
            if (token.isComment()) {
                currentNode.appendChild(new CommentImpl("\n" + token.getValue() + "\n", currentNode));
                ++this.treeSize;
                continue;
            }
            if (token.isText()) {
                String value;
                if (candidate instanceof Title) {
                    title = title + token.getValue();
                    title = StringServices.replace(title, "\n", " ");
                    title = title.trim();
                }
                if (skip) continue;
                if ((currentNode instanceof Body || currentNode instanceof Li) && !token.isWhitespace()) {
                    P para = new P();
                    para.setParentNode(currentNode);
                    currentNode.appendChild(para);
                    ++this.treeSize;
                    currentNode = para;
                    this.addOpenTag(para);
                }
                if (currentNode instanceof Pre || currentNode.findParent(Pre.class) != null) {
                    value = token.getValue();
                    value = HtmlServices.textToHtml(value);
                    logger.debug((Object)("Adding text to literal environment.\n'" + value + "'."));
                    currentNode.appendChild(new TextImpl(value, currentNode));
                    ++this.treeSize;
                } else if (!token.isWhitespace()) {
                    value = token.getValue();
                    value = ReplaceServices.replaceAll(value, "[\\t ]+", " ");
                    value = ReplaceServices.replaceAll(value, "\\s+$", " ");
                    currentNode.appendChild(new TextImpl(HtmlServices.textToHtml(value), currentNode));
                    ++this.treeSize;
                }
            }
            if (token.isOpeningTag()) {
                NodeImpl parent;
                int i;
                tagName = token.getTagName();
                if (tagName == null) continue;
                tagName = tagName.toLowerCase();
                if (skip && skipTo.equals(tagName)) {
                    logger.debug((Object)("Setting skip to false. Found tag " + tagName + "."));
                    skip = false;
                }
                nesting = this.closeOpenTag(tagName, currentNode);
                NodeImpl node = currentNode;
                for (i = 0; i < nesting; ++i) {
                    if (node == null || (parent = node.getTrafoParentNode()) == null) continue;
                    logger.debug((Object)("Closing node = " + node));
                    logger.debug((Object)("New current node = " + parent));
                    node = parent;
                }
                candidate = this.createElement(token, node);
                if (candidate == null) continue;
                logger.debug((Object)("Created candidate = " + candidate));
                if (!this.checkCodeContext(candidate)) {
                    logger.debug((Object)("Candidate is not allowed in this code context(" + this.codeContext + ") '" + candidate + "'!"));
                    continue;
                }
                logger.debug((Object)("Candidate is valid: " + candidate));
                if (!skip) {
                    for (i = 0; i < nesting; ++i) {
                        this.removeOpenTag();
                        if (currentNode == null || (parent = currentNode.getTrafoParentNode()) == null) continue;
                        currentNode = parent;
                    }
                    if (currentNode instanceof HtmlDocument) {
                        ((HtmlDocument)currentNode).setDocumentElement(candidate);
                    }
                    currentNode.appendChild(candidate);
                    ++this.treeSize;
                    if (!candidate.isEmpty()) {
                        this.addOpenTag(candidate);
                        currentNode = candidate;
                    }
                } else {
                    logger.debug((Object)"Skipped candidate.");
                }
            }
            if (!token.isClosingTag() || skip || currentNode == null) continue;
            nesting = this.closeClosingTag(token.getTagName().toLowerCase(), currentNode);
            logger.debug((Object)("Nesting = " + nesting));
            for (int j = 0; j < nesting; ++j) {
                if (currentNode == null || currentNode.getParentNode() == null) continue;
                currentNode = currentNode.getTrafoParentNode();
            }
        }
        this.postparse(root, root);
        if (errorBuffer != null && errorBuffer.length() > 0) {
            root.appendChild(new CommentImpl("ERRORS:\n" + errorBuffer));
            ++this.treeSize;
        }
        return rc;
    }

    private ElementImpl removeOpenTag() {
        this.openTags.pop();
        HtmlElement node = (HtmlElement)this.openElements.pop();
        node.closed();
        return node;
    }
}

