/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.herold;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.herold.ConsoleProgressListener;
import org.dbdoclet.option.BooleanOption;
import org.dbdoclet.option.FileOption;
import org.dbdoclet.option.Option;
import org.dbdoclet.option.OptionException;
import org.dbdoclet.option.OptionList;
import org.dbdoclet.option.SelectOption;
import org.dbdoclet.option.StringOption;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.trafo.AbstractTrafoService;
import org.dbdoclet.trafo.TrafoException;
import org.dbdoclet.trafo.TrafoExceptionHandler;
import org.dbdoclet.trafo.TrafoResult;
import org.dbdoclet.trafo.TrafoScriptManager;
import org.dbdoclet.trafo.html.dita.HtmlDitaTrafo;
import org.dbdoclet.trafo.html.docbook.HtmlDocBookTrafo;
import org.dbdoclet.trafo.param.BooleanParam;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.Section;

public class Herold {
    private static Log logger = LogFactory.getLog(Herold.class);
    private int exitCode;
    private FileOption optIn;
    private FileOption optOut;
    private OutputFormat outputFormat;
    private ResourceBundle res = ResourceBundle.getBundle("org/dbdoclet/herold/Resources");
    private boolean systemExitEnabled = true;
    private boolean verbose = false;

    private static String getVersion() {
        Package p = Herold.class.getPackage();
        return p.getImplementationVersion();
    }

    public static void main(String[] args) {
        Herold herold = new Herold();
        herold.execute(args);
    }

    private static void printLicense() throws IOException {
        URL url = ResourceServices.getResourceAsUrl("/org/dbdoclet/herold/COPYING");
        if (url != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = reader.readLine();
            while (line != null) {
                Herold.println(line);
                line = reader.readLine();
            }
            reader.close();
        } else {
            logger.fatal((Object)"Can't find resource for license!");
        }
    }

    private static void println(String str) {
        System.out.println(str);
    }

    private static void printVersion() {
        Herold.println("herold version \"" + Herold.getVersion() + "\"");
    }

    public void convert(File htmlFile, File xmlFile) throws TrafoException, FileNotFoundException {
        Script script = new Script();
        this.convert(new FileInputStream(htmlFile), new FileOutputStream(xmlFile), xmlFile, script);
    }

    public void convert(InputStream in, OutputStream out, File systemId, Script script) throws TrafoException {
        AbstractTrafoService trafo = new HtmlDocBookTrafo();
        if (this.outputFormat == OutputFormat.DITA) {
            trafo = new HtmlDitaTrafo();
        }
        trafo.setSystemId(systemId);
        trafo.setInputStream(in);
        trafo.setOutputStream(out);
        TrafoResult result = null;
        if (this.verbose) {
            trafo.addProgressListener(new ConsoleProgressListener(false));
            result = trafo.transform(script);
        } else {
            result = trafo.transform(script);
        }
        if (result.isFailed()) {
            System.err.print(result.toString());
        }
        if (this.verbose) {
            System.out.println();
        }
    }

    private OptionList createOptionList(String[] args) {
        OptionList options = new OptionList(args);
        BooleanOption bopt = new BooleanOption("DocBook".toLowerCase() + "-" + "add-index", "x");
        bopt.setValue(false);
        options.add(bopt);
        StringOption sopt = new StringOption("DocBook".toLowerCase() + "-" + "encoding", "d");
        sopt.setDefault("UTF-8");
        options.add(sopt);
        bopt = new BooleanOption("DocBook".toLowerCase() + "-" + "decompose-tables", "T");
        bopt.setDefault(false);
        options.add(bopt);
        SelectOption selopt = new SelectOption("DocBook".toLowerCase() + "-" + "document-element", "r");
        String[] optv2 = new String[]{"article", "book", "reference", "part", "chapter", "section"};
        selopt.setList(optv2);
        selopt.setDefault("article");
        options.add(selopt);
        sopt = new StringOption("DocBook".toLowerCase() + "-" + "title", "t");
        sopt.setDefault("http://www.dbdoclet.org/herold");
        options.add(sopt);
        sopt = new StringOption("HTML".toLowerCase() + "-" + "encoding", "s");
        sopt.setDefault("UTF-8");
        options.add(sopt);
        this.optIn = new FileOption("in", "i");
        this.optIn.isExisting(true);
        options.add(this.optIn);
        SelectOption optLogLevel = new SelectOption("logging-level", "l");
        optLogLevel.setList(new String[]{"debug5", "debug4", "debug3", "debug2", "debug", "info", "warn", "error", "fatal"});
        optLogLevel.setDefault("error");
        options.add(optLogLevel);
        this.optOut = new FileOption("out", "o");
        options.add(this.optOut);
        StringOption optProfile = new StringOption("profile", "p");
        options.add(optProfile);
        BooleanOption option = new BooleanOption("verbose", "v");
        options.add(option);
        return options;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    private OutputStream createOutputStream() throws FileNotFoundException {
        OutputStream out;
        if (this.optOut.isUnset()) {
            out = System.out;
        } else {
            File outDir = ((File)this.optOut.getValue()).getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdir();
            }
            out = new FileOutputStream((File)this.optOut.getValue());
        }
        return out;
    }

    public void execute(String[] args) {
        OptionList options = null;
        this.exitCode = 0;
        try {
            File outFile;
            options = new OptionList(args);
            BooleanOption option = new BooleanOption("help", "h");
            option.setMediumName("?");
            options.add(option);
            option = new BooleanOption("license", "L");
            options.add(option);
            option = new BooleanOption("version", "V");
            options.add(option);
            options.validate(true);
            if (options.getFlag("help", false)) {
                this.printUsage();
                return;
            }
            if (options.getFlag("version", false)) {
                Herold.printVersion();
                return;
            }
            if (options.getFlag("license", false)) {
                Herold.printLicense();
                this.exit(0);
            }
            if (!(options = this.createOptionList(args)).validate()) {
                throw new OptionException(options.getError());
            }
            StringOption optProfile = (StringOption)options.getOption("profile");
            File profileFile = this.findProfile(optProfile);
            TrafoScriptManager mgr = new TrafoScriptManager();
            Script script = mgr.parseScript(profileFile);
            logger.info((Object)String.format("Using profile file %s.", profileFile.getAbsolutePath()));
            if (logger.isTraceEnabled()) {
                StringWriter buffer = new StringWriter();
                mgr.writeScript(script, buffer);
                logger.trace((Object)("Script: " + buffer.toString()));
            }
            if ((outFile = this.processCommandLineOptions(options, script)) != null) {
                logger.info((Object)String.format("Output file is %s.", outFile.getPath()));
            }
            InputStream in = null;
            OutputStream out = null;
            in = this.optIn.isUnset() ? System.in : new FileInputStream((File)this.optIn.getValue());
            out = this.createOutputStream();
            this.convert(in, out, (File)this.optOut.getValue(), script);
        }
        catch (OptionException oops) {
            if (options != null && !options.getFlag("help", false)) {
                this.printUsage();
                String msg = oops.getMessage();
                if (msg != null) {
                    System.err.println(msg);
                }
            } else {
                oops.printStackTrace();
                this.printUsage();
            }
            this.exitCode = 1;
        }
        catch (TrafoException oops) {
            logger.fatal((Object)"TrafoException", TrafoExceptionHandler.getCause(oops));
            this.exitCode = 2;
        }
        catch (FileNotFoundException oops) {
            logger.fatal((Object)oops.getMessage());
            this.exitCode = 3;
        }
        catch (IOException oops) {
            oops.printStackTrace();
            this.exitCode = 4;
        }
        catch (Exception oops) {
            oops.printStackTrace();
            this.exitCode = 5;
        }
        this.exit(this.exitCode);
    }

    private void exit(int exitCode) {
        this.exitCode = exitCode;
        if (this.systemExitEnabled) {
            System.exit(exitCode);
        }
    }

    private File findProfile(StringOption optProfile) throws FileNotFoundException {
        File profile;
        String profileName = "default.her";
        if (!optProfile.isUnset()) {
            profileName = (String)optProfile.getValue();
        }
        if (profileName == null || profileName.trim().length() == 0) {
            profileName = "default.her";
        }
        if ((profile = new File(profileName)).exists()) {
            return profile;
        }
        String homePath = System.getProperty("herold.home");
        if (homePath != null) {
            File homeDir = new File(homePath);
            if (!homeDir.exists()) {
                throw new FileNotFoundException(String.format("Home directory %s does not exist!", homePath));
            }
            File profilesDir = new File(homeDir, "profiles");
            if (!profilesDir.exists()) {
                throw new FileNotFoundException(String.format("Profiles directory %s does not exist!", profilesDir.getAbsolutePath()));
            }
            File file = new File(profilesDir, profileName);
            if (file.exists()) {
                return file;
            }
            file = new File(profilesDir, profileName + ".her");
            if (file.exists()) {
                return file;
            }
        }
        throw new FileNotFoundException(String.format("Profile %s does not exist!", profileName));
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isCanceled() {
        return false;
    }

    private void printUsage() {
        try {
            String resname = ResourceServices.getString(this.res, "C_USAGE");
            String buffer = ResourceServices.getResourceAsString(resname);
            Herold.println(MessageFormat.format(buffer, Herold.getVersion()));
        }
        catch (IOException oops) {
            logger.fatal((Object)"Printing usage message failed!", (Throwable)oops);
        }
    }

    public File processCommandLineOptions(OptionList options, Script script) {
        File outFile;
        Namespace namespace = script.getNamespace();
        Section section = null;
        block3: for (Option<?> option : options) {
            String name = option.getLongName();
            if (name.startsWith("DocBook".toLowerCase())) {
                section = namespace.findOrCreateSection("DocBook");
                name = StringServices.cutPrefix(name, "DocBook".toLowerCase());
            } else if (name.startsWith("HTML".toLowerCase())) {
                section = namespace.findOrCreateSection("HTML");
                name = StringServices.cutPrefix(name, "HTML".toLowerCase());
            }
            name = StringServices.cutPrefix(name, "-");
            if (section == null || option.isUnset()) continue;
            switch (option.getType()) {
                case BOOLEAN: {
                    section.setParam(new BooleanParam(name, (Boolean)option.getValue()));
                    continue block3;
                }
            }
            section.setParam(new TextParam(name, option.getValue().toString()));
        }
        this.setVerbose(options.getFlag("verbose", false));
        if (this.optOut == null) {
            throw new IllegalStateException("The field optOut must not be null!");
        }
        if (this.optIn == null) {
            throw new IllegalStateException("The field optIn must not be null!");
        }
        if (this.optOut.isUnset() && !this.optIn.isUnset()) {
            String outFileName = FileServices.getFileBase((File)this.optIn.getValue()) + ".xml";
            outFile = new File(outFileName);
        } else {
            outFile = (File)this.optOut.getValue();
        }
        return outFile;
    }

    public void setSystemExitEnabled(boolean systemExitEnabled) {
        this.systemExitEnabled = systemExitEnabled;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static enum OutputFormat {
        DITA,
        DocBook;

    }
}

