/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.herold;

import org.dbdoclet.progress.ProgressAdapter;
import org.dbdoclet.progress.ProgressEvent;

public class ConsoleProgressListener
extends ProgressAdapter {
    private static final int DEFAULT_LINE_WIDTH = 77;
    private int prepareCounter = 0;
    private int actionCounter = 0;
    private final boolean dumb;
    private int lastPercent = 0;
    private ProgressEvent lastEvent;
    private int barWidth;
    private int lineWidth;
    private String lastLine;

    public ConsoleProgressListener(boolean dumb) {
        this.dumb = dumb;
        int lineWidth = 77;
        String value = System.getProperty("console.lineWidth");
        if (value != null) {
            try {
                lineWidth = Integer.parseInt(value);
            }
            catch (Exception e) {
                lineWidth = 77;
            }
        }
        this.setLineWidth(lineWidth);
    }

    @Override
    public boolean progress(ProgressEvent event) {
        if (this.lastEvent != null && this.lastEvent.getStage() == 2 && this.lastEvent.getConsider() && (event.getStage() != 2 || !event.getConsider())) {
            this.printBar(100);
        }
        if (!event.getConsider()) {
            this.print("\n" + event.getAction() + "\n");
            this.lastEvent = event;
            return true;
        }
        if (event.getStage() == 1) {
            this.stagePrepare(event);
        }
        if (event.getStage() == 2) {
            ++this.actionCounter;
            int percent = 0;
            int max = this.getProgressMaximum();
            if (max > 0) {
                percent = 100 * this.actionCounter / this.getProgressMaximum();
            }
            if (percent > 100) {
                percent = 100;
            }
            this.printBar(percent);
        }
        this.lastEvent = event;
        return true;
    }

    private void stagePrepare(ProgressEvent event) {
        if (!this.dumb) {
            StringBuilder buffer = new StringBuilder(String.valueOf(++this.prepareCounter));
            buffer.append(' ');
            String action = event.getAction();
            if (action != null) {
                action = action.replaceAll("\n", " ").trim();
                action = action.replaceAll("\r", " ").trim();
                buffer.append(action);
            }
            while (buffer.length() < this.lineWidth) {
                buffer.append(' ');
            }
            if (buffer.length() > this.lineWidth) {
                buffer = buffer.delete(this.lineWidth, buffer.length());
            }
            this.print(buffer.toString() + "\r");
        }
    }

    private void printBar(int percent) {
        int i;
        int pos = 0;
        if (percent > 0) {
            pos = (int)((float)percent * ((float)this.barWidth / 100.0f));
        }
        StringBuilder buffer = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            buffer.append('#');
        }
        for (i = pos; i < this.barWidth; ++i) {
            buffer.append(' ');
        }
        if (this.dumb) {
            if (percent != this.lastPercent) {
                System.out.println(percent + "%");
                this.lastPercent = percent;
            }
        } else {
            String line = String.format(" %3d%% |%s| 100%%\r", percent, buffer.toString());
            this.print(line);
        }
    }

    @Override
    public void setProgressMaximum(int max) {
        super.setProgressMaximum(max);
        this.actionCounter = 0;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 15) {
            return;
        }
        this.lineWidth = lineWidth;
        this.barWidth = lineWidth - 13;
    }

    private void print(String line) {
        if (this.lastLine != null && line.equals(this.lastLine)) {
            return;
        }
        System.out.print(line);
        this.lastLine = line;
    }
}

