/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.config;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Flag;

public abstract class FlagBindingModule
extends AbstractModule {
    protected void bindFlags(ExtensionContext context) {
        for (Method method : context.getClass().getMethods()) {
            Object flagValue;
            boolean isFlagMethod = method.isAnnotationPresent(Flag.class);
            if (!isFlagMethod) continue;
            Class<?> returnType = method.getReturnType();
            try {
                flagValue = method.invoke((Object)context, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not get flag value by invoking: " + method.getName(), e);
            }
            Preconditions.checkNotNull((Object)flagValue, (Object)("Required flag " + method.getName() + " was mull"));
            this.bind(returnType).annotatedWith((Annotation)Names.named((String)method.getName())).toInstance(flagValue);
        }
    }
}

