/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.JodaLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.types.converters.JodaLocalTimeStringConverter;
import org.joda.time.LocalTime;

public class JodaLocalTimeLiteral
extends JodaLiteral {
    private final LocalTime value;

    public JodaLocalTimeLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, mapping, parameterName);
        if (value == null) {
            this.value = null;
        } else if (value instanceof LocalTime) {
            this.value = (LocalTime)value;
        } else {
            throw new NucleusException("Cannot create " + ((Object)((Object)this)).getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String str = new JodaLocalTimeStringConverter().toDatastoreType((LocalTime)value);
            this.delegate = new StringLiteral(stmt, mapping, (Object)(this.value != null ? str : null), parameterName);
        } else if (this.value != null) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(11, this.value.getHourOfDay());
            cal.set(12, this.value.getMinuteOfHour());
            cal.set(13, this.value.getSecondOfMinute());
            this.delegate = new TemporalLiteral(stmt, mapping, (Object)cal.getTime(), parameterName);
        } else {
            this.delegate = new TemporalLiteral(stmt, mapping, null, parameterName);
        }
    }

    public Object getValue() {
        return this.value;
    }
}

