/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.JodaLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.types.converters.JodaDurationStringConverter;
import org.joda.time.Duration;

public class JodaDurationLiteral
extends JodaLiteral {
    private final Duration value;

    public JodaDurationLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, mapping, parameterName);
        if (value == null) {
            this.value = null;
        } else if (value instanceof Duration) {
            this.value = (Duration)value;
        } else {
            throw new NucleusException("Cannot create " + ((Object)((Object)this)).getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String str = new JodaDurationStringConverter().toDatastoreType((Duration)value);
            this.delegate = new StringLiteral(stmt, mapping, (Object)(this.value != null ? str : null), parameterName);
        } else {
            this.delegate = this.value != null ? new IntegerLiteral(stmt, mapping, (Object)((Duration)value).getMillis(), parameterName) : new IntegerLiteral(stmt, mapping, null, parameterName);
        }
    }

    public Object getValue() {
        return this.value;
    }
}

