/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Hashing;

public class RedisShardedConnPool
implements ConnectionPool<ShardedJedis> {
    private final ShardedJedisPool pool;

    public RedisShardedConnPool(PoolConfig poolConfig, List<JedisShardInfo> shards) {
        this(poolConfig, shards, Hashing.MURMUR_HASH);
    }

    public RedisShardedConnPool(PoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo) {
        this(poolConfig, shards, algo, null);
    }

    public RedisShardedConnPool(PoolConfig poolConfig, List<JedisShardInfo> shards, Pattern keyTagPattern) {
        this(poolConfig, shards, Hashing.MURMUR_HASH, keyTagPattern);
    }

    public RedisShardedConnPool(PoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        this.pool = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards, algo, keyTagPattern);
    }

    @Override
    public ShardedJedis getConnection() {
        return this.pool.getResource();
    }

    @Override
    public void returnConnection(ShardedJedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public void invalidateConnection(ShardedJedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    public void close() {
        this.pool.close();
    }
}

