/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.redis.RedisConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelConnPool
implements ConnectionPool<Jedis> {
    private final JedisSentinelPool pool;

    protected RedisSentinelConnPool(JedisSentinelPool pool) {
        this.pool = pool;
    }

    public RedisSentinelConnPool(String masterName, Set<String> sentinels) {
        this(new PoolConfig(), masterName, sentinels);
    }

    public RedisSentinelConnPool(PoolConfig poolConfig, String masterName, Set<String> sentinels) {
        this(poolConfig, masterName, sentinels, 2000, 2000, RedisConfig.DEFAULT_PASSWORD, 0, RedisConfig.DEFAULT_CLIENTNAME);
    }

    public RedisSentinelConnPool(Properties properties) {
        this(new PoolConfig(), properties);
    }

    public RedisSentinelConnPool(PoolConfig poolConfig, Properties properties) {
        this(poolConfig, properties.getProperty("masterName"), new HashSet<String>(Arrays.asList(properties.getProperty("sentinels").split(","))), Integer.parseInt(properties.getProperty("timeout", String.valueOf(2000))), Integer.parseInt(properties.getProperty("timeout", String.valueOf(2000))), properties.getProperty("password"), Integer.parseInt(properties.getProperty("database", String.valueOf(0))), properties.getProperty("clientName"));
    }

    public RedisSentinelConnPool(PoolConfig poolConfig, String masterName, Set<String> sentinels, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this.pool = new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)poolConfig, connectionTimeout, soTimeout, password, database, clientName);
    }

    @Override
    public Jedis getConnection() {
        return this.pool.getResource();
    }

    @Override
    public void returnConnection(Jedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public void invalidateConnection(Jedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    public void close() {
        this.pool.close();
    }
}

