/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.redis.RedisConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisConnectionPool
implements ConnectionPool<Jedis> {
    private final JedisPool pool;

    public RedisConnectionPool(String host, int port) {
        this(new PoolConfig(), host, port);
    }

    public RedisConnectionPool(PoolConfig poolConfig, String host, int port) {
        this(poolConfig, host, port, 2000, RedisConfig.DEFAULT_PASSWORD, 0, RedisConfig.DEFAULT_CLIENTNAME);
    }

    public RedisConnectionPool(Properties properties) {
        this(new PoolConfig(), properties);
    }

    public RedisConnectionPool(PoolConfig poolConfig, Properties properties) {
        this(poolConfig, properties.getProperty("address").split(":")[0], Integer.parseInt(properties.getProperty("address").split(":")[1]), Integer.parseInt(properties.getProperty("timeout", String.valueOf(2000))), properties.getProperty("password"), Integer.parseInt(properties.getProperty("database", String.valueOf(0))), properties.getProperty("clientName"));
    }

    public RedisConnectionPool(PoolConfig poolConfig, String host, int port, int timeout, String password, int database, String clientName) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName);
    }

    public RedisConnectionPool(PoolConfig poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, connectionTimeout, soTimeout, password, database, clientName, false, null, null, null);
    }

    @Override
    public Jedis getConnection() {
        return this.pool.getResource();
    }

    @Override
    public void returnConnection(Jedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public void invalidateConnection(Jedis conn) {
        if (conn != null) {
            conn.close();
        }
    }

    public void close() {
        this.pool.close();
    }
}

