/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.redis.RedisConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class RedisClusterConnPool
implements ConnectionPool<JedisCluster> {
    private final JedisCluster jedisCluster;

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes) {
        this(clusterNodes, 2000);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int timeout) {
        this(clusterNodes, timeout, timeout);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int connectionTimeout, int soTimeout) {
        this(clusterNodes, connectionTimeout, soTimeout, 5);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int connectionTimeout, int soTimeout, int maxAttempts) {
        this(clusterNodes, connectionTimeout, soTimeout, maxAttempts, new PoolConfig());
    }

    public RedisClusterConnPool(Properties properties) {
        this(new PoolConfig(), properties);
    }

    public RedisClusterConnPool(PoolConfig poolConfig, Properties properties) {
        HashSet<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
        for (String hostAndPort : properties.getProperty("cluster").split(",")) {
            jedisClusterNodes.add(new HostAndPort(hostAndPort.split(":")[0], Integer.valueOf(hostAndPort.split(":")[1]).intValue()));
        }
        int timeout = Integer.parseInt(properties.getProperty("timeout", String.valueOf(2000)));
        int maxAttempts = Integer.valueOf(properties.getProperty("maxAttempts", String.valueOf(5)));
        String password = properties.getProperty("password", RedisConfig.DEFAULT_PASSWORD);
        this.jedisCluster = new JedisCluster(jedisClusterNodes, timeout, timeout, maxAttempts, password, (GenericObjectPoolConfig)poolConfig);
    }

    public RedisClusterConnPool(PoolConfig poolConfig, Set<HostAndPort> clusterNodes) {
        this(clusterNodes, 2000, 5, poolConfig);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int timeout, int maxAttempts, PoolConfig poolConfig) {
        this(clusterNodes, timeout, timeout, maxAttempts, RedisConfig.DEFAULT_PASSWORD, poolConfig);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int connectionTimeout, int soTimeout, int maxAttempts, PoolConfig poolConfig) {
        this(clusterNodes, connectionTimeout, soTimeout, maxAttempts, RedisConfig.DEFAULT_PASSWORD, poolConfig);
    }

    public RedisClusterConnPool(Set<HostAndPort> clusterNodes, int connectionTimeout, int soTimeout, int maxAttempts, String password, PoolConfig poolConfig) {
        this.jedisCluster = new JedisCluster(clusterNodes, connectionTimeout, soTimeout, maxAttempts, password, (GenericObjectPoolConfig)poolConfig);
    }

    @Override
    public JedisCluster getConnection() {
        return this.jedisCluster;
    }

    @Override
    public void returnConnection(JedisCluster conn) {
    }

    @Override
    public void invalidateConnection(JedisCluster conn) {
    }

    public void close() throws IOException {
        this.jedisCluster.close();
    }
}

