/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolBase;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.kafka.KafkaConnectionFactory;

public class KafkaConnectionPool
extends PoolBase<Producer<byte[], byte[]>>
implements ConnectionPool<Producer<byte[], byte[]>> {
    private static final long serialVersionUID = -1506435964498488591L;

    public KafkaConnectionPool() {
        this("localhost:9092");
    }

    public KafkaConnectionPool(String brokers) {
        this(new PoolConfig(), brokers);
    }

    public KafkaConnectionPool(Properties props) {
        this(new PoolConfig(), new ProducerConfig(props));
    }

    public KafkaConnectionPool(ProducerConfig config) {
        this(new PoolConfig(), config);
    }

    public KafkaConnectionPool(PoolConfig poolConfig, Properties props) {
        this(poolConfig, new ProducerConfig(props));
    }

    public KafkaConnectionPool(PoolConfig poolConfig, String brokers) {
        this(poolConfig, brokers, "sync", "0", "none", "200");
    }

    public KafkaConnectionPool(PoolConfig poolConfig, String brokers, String type) {
        this(poolConfig, brokers, type, "0", "none", "200");
    }

    public KafkaConnectionPool(PoolConfig poolConfig, ProducerConfig config) {
        super(poolConfig, new KafkaConnectionFactory(config));
    }

    public KafkaConnectionPool(PoolConfig poolConfig, String brokers, String type, String acks, String codec, String batch) {
        super(poolConfig, new KafkaConnectionFactory(brokers, type, acks, codec, batch));
    }

    @Override
    public Producer<byte[], byte[]> getConnection() {
        return (Producer)super.getResource();
    }

    @Override
    public void returnConnection(Producer<byte[], byte[]> conn) {
        super.returnResource(conn);
    }

    @Override
    public void invalidateConnection(Producer<byte[], byte[]> conn) {
        super.invalidateResource(conn);
    }
}

