/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.socket;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionFactory;

class SocketConnectionFactory
implements ConnectionFactory<Socket> {
    private static final long serialVersionUID = -727722488965747494L;
    private final InetSocketAddress socketAddress;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final int connectionTimeout;
    private final int soTimeout;
    private final boolean keepAlive;
    private final boolean tcpNoDelay;
    private final String[] performance;
    private int linger;

    public SocketConnectionFactory(Properties properties) {
        String address = properties.getProperty("address");
        if (address == null) {
            throw new ConnectionException("[address] is required !");
        }
        this.socketAddress = new InetSocketAddress(address.split(":")[0], Integer.parseInt(address.split(":")[1]));
        this.receiveBufferSize = Integer.parseInt(properties.getProperty("receiveBufferSize", "0"));
        this.sendBufferSize = Integer.parseInt(properties.getProperty("sendBufferSize", "0"));
        this.connectionTimeout = Integer.parseInt(properties.getProperty("connectionTimeout", "0"));
        this.soTimeout = Integer.parseInt(properties.getProperty("soTimeout", "0"));
        this.linger = Integer.parseInt(properties.getProperty("linger", "0"));
        this.keepAlive = Boolean.valueOf(properties.getProperty("keepAlive", "false"));
        this.tcpNoDelay = Boolean.valueOf(properties.getProperty("tcpNoDelay", "false"));
        this.performance = properties.getProperty("performance") != null ? properties.getProperty("performance").split(",") : null;
    }

    public SocketConnectionFactory(String host, int port, int receiveBufferSize, int sendBufferSize, int connectionTimeout, int soTimeout, int linger, boolean keepAlive, boolean tcpNoDelay, String[] performance) {
        this.socketAddress = new InetSocketAddress(host, port);
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.linger = linger;
        this.keepAlive = keepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.performance = performance;
    }

    public PooledObject<Socket> makeObject() throws Exception {
        Socket socket = this.createConnection();
        return new DefaultPooledObject((Object)socket);
    }

    public void destroyObject(PooledObject<Socket> p) throws Exception {
        Socket socket = (Socket)p.getObject();
        if (socket != null) {
            socket.close();
        }
    }

    public boolean validateObject(PooledObject<Socket> p) {
        Socket socket = (Socket)p.getObject();
        if (socket != null) {
            return socket.isConnected() && !socket.isClosed();
        }
        return false;
    }

    public void activateObject(PooledObject<Socket> p) throws Exception {
    }

    public void passivateObject(PooledObject<Socket> p) throws Exception {
    }

    @Override
    public Socket createConnection() throws Exception {
        Socket socket = new Socket();
        try {
            if (this.sendBufferSize > 0) {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            if (this.receiveBufferSize > 0) {
                socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.soTimeout > 0) {
                socket.setSoTimeout(this.soTimeout);
            }
            if (this.linger > 0) {
                socket.setSoLinger(true, this.linger);
            }
            if (this.keepAlive) {
                socket.setKeepAlive(this.keepAlive);
            }
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            if (this.performance != null) {
                socket.setPerformancePreferences(Integer.parseInt(this.performance[0]), Integer.parseInt(this.performance[1]), Integer.parseInt(this.performance[2]));
            }
            socket.connect(this.socketAddress, this.connectionTimeout);
        }
        catch (Exception se) {
            socket.close();
            throw se;
        }
        return socket;
    }
}

