/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@Deprecated
class RedisConnectionFactoryOld
implements ConnectionFactory<Jedis> {
    private static final long serialVersionUID = 5692815845396189037L;
    private final AtomicReference<HostAndPort> hostAndPort = new AtomicReference();
    private final int connectionTimeout;
    private final int soTimeout;
    private final String password;
    private final int database;
    private final String clientName;

    public RedisConnectionFactoryOld(String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this.hostAndPort.set(new HostAndPort(host, port));
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
    }

    public RedisConnectionFactoryOld(Properties properties) {
        String address = properties.getProperty("address");
        if (address == null) {
            throw new ConnectionException("[address] is required !");
        }
        this.hostAndPort.set(new HostAndPort(address.split(":")[0], Integer.parseInt(address.split(":")[1])));
        this.connectionTimeout = Integer.parseInt(properties.getProperty("connectionTimeout", String.valueOf(2000)));
        this.soTimeout = Integer.parseInt(properties.getProperty("soTimeout", String.valueOf(2000)));
        this.database = Integer.parseInt(properties.getProperty("database", String.valueOf(0)));
        this.password = properties.getProperty("password");
        this.clientName = properties.getProperty("clientName");
    }

    public void setHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort.set(hostAndPort);
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        Jedis jedis = this.createConnection();
        return new DefaultPooledObject((Object)jedis);
    }

    public void destroyObject(PooledObject<Jedis> p) throws Exception {
        BinaryJedis jedis = (BinaryJedis)p.getObject();
        if (!jedis.isConnected()) {
            return;
        }
        try {
            try {
                jedis.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jedis.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean validateObject(PooledObject<Jedis> p) {
        BinaryJedis jedis = (BinaryJedis)p.getObject();
        try {
            HostAndPort hostAndPort = this.hostAndPort.get();
            String connectionHost = jedis.getClient().getHost();
            int connectionPort = jedis.getClient().getPort();
            return hostAndPort.getHost().equals(connectionHost) && hostAndPort.getPort() == connectionPort && jedis.isConnected() && jedis.ping().equals("PONG");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void activateObject(PooledObject<Jedis> p) throws Exception {
        BinaryJedis jedis = (BinaryJedis)p.getObject();
        if (jedis.getDB() != (long)this.database) {
            jedis.select(this.database);
        }
    }

    public void passivateObject(PooledObject<Jedis> p) throws Exception {
    }

    @Override
    public Jedis createConnection() throws Exception {
        HostAndPort hostAndPort = this.hostAndPort.get();
        Jedis jedis = new Jedis(hostAndPort.getHost(), hostAndPort.getPort(), this.connectionTimeout, this.soTimeout);
        try {
            jedis.connect();
            if (null != this.password) {
                jedis.auth(this.password);
            }
            if (this.database != 0) {
                jedis.select(this.database);
            }
            if (this.clientName != null) {
                jedis.clientSetname(this.clientName);
            }
        }
        catch (Exception je) {
            jedis.close();
            throw je;
        }
        return jedis;
    }
}

