/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionFactory;

class KafkaConnectionFactory
implements ConnectionFactory<Producer<byte[], byte[]>> {
    private static final long serialVersionUID = 8271607366818512399L;
    private final ProducerConfig config;

    public KafkaConnectionFactory(ProducerConfig config) {
        this.config = config;
    }

    public KafkaConnectionFactory(String brokers, String type, String acks, String codec, String batch) {
        Properties props = new Properties();
        props.setProperty("metadata.broker.list", brokers);
        props.setProperty("producer.type", type);
        props.setProperty("request.required.acks", acks);
        props.setProperty("compression.codec", codec);
        props.setProperty("batch.num.messages", batch);
        this.config = new ProducerConfig(props);
    }

    public KafkaConnectionFactory(Properties properties) {
        String brokers = properties.getProperty("metadata.broker.list");
        if (brokers == null) {
            throw new ConnectionException("[metadata.broker.list] is required !");
        }
        this.config = new ProducerConfig(properties);
    }

    public PooledObject<Producer<byte[], byte[]>> makeObject() throws Exception {
        Producer<byte[], byte[]> producer = this.createConnection();
        return new DefaultPooledObject(producer);
    }

    public void destroyObject(PooledObject<Producer<byte[], byte[]>> p) throws Exception {
        Producer producer = (Producer)p.getObject();
        if (null != producer) {
            producer.close();
        }
    }

    public boolean validateObject(PooledObject<Producer<byte[], byte[]>> p) {
        Producer producer = (Producer)p.getObject();
        return null != producer;
    }

    public void activateObject(PooledObject<Producer<byte[], byte[]>> p) throws Exception {
    }

    public void passivateObject(PooledObject<Producer<byte[], byte[]>> p) throws Exception {
    }

    @Override
    public Producer<byte[], byte[]> createConnection() throws Exception {
        Producer producer = new Producer(this.config);
        return producer;
    }
}

