/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionFactory;

class JdbcConnectionFactory
implements ConnectionFactory<Connection> {
    private static final long serialVersionUID = 4941500146671191616L;
    private final String driverClass;
    private final String jdbcUrl;
    private final String username;
    private final String password;

    public JdbcConnectionFactory(Properties properties) {
        this.driverClass = properties.getProperty("driverClass");
        if (this.driverClass == null) {
            throw new ConnectionException("[driverClass] is required !");
        }
        this.jdbcUrl = properties.getProperty("jdbcUrl");
        if (this.jdbcUrl == null) {
            throw new ConnectionException("[jdbcUrl] is required !");
        }
        this.username = properties.getProperty("username");
        if (this.username == null) {
            throw new ConnectionException("[username] is required !");
        }
        this.password = properties.getProperty("password");
        if (this.password == null) {
            throw new ConnectionException("[password] is required !");
        }
        this.loadDriver();
    }

    public JdbcConnectionFactory(String driverClass, String jdbcUrl, String username, String password) {
        this.driverClass = driverClass;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.loadDriver();
    }

    private void loadDriver() {
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        Connection connection = this.createConnection();
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<Connection> p) throws Exception {
        Connection connection = (Connection)p.getObject();
        if (connection != null) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<Connection> p) {
        Connection connection = (Connection)p.getObject();
        if (connection != null) {
            try {
                return !connection.isClosed() && connection.isValid(1);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void activateObject(PooledObject<Connection> p) throws Exception {
    }

    public void passivateObject(PooledObject<Connection> p) throws Exception {
    }

    @Override
    public Connection createConnection() throws Exception {
        Connection connection = DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
        return connection;
    }
}

