/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.hbase;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolBase;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.hbase.HbaseConfig;
import org.darkphoenixs.pool.hbase.HbaseConnectionFactory;

public class HbaseConnectionPool
extends PoolBase<Connection>
implements ConnectionPool<Connection> {
    private static final long serialVersionUID = -9126420905798370243L;

    public HbaseConnectionPool() {
        this("localhost", "2181");
    }

    public HbaseConnectionPool(String host, String port) {
        this(new PoolConfig(), host, port, HbaseConfig.DEFAULT_MASTER, HbaseConfig.DEFAULT_ROOTDIR);
    }

    public HbaseConnectionPool(String host, String port, String master, String rootdir) {
        this(new PoolConfig(), host, port, master, rootdir);
    }

    public HbaseConnectionPool(Configuration hadoopConfiguration) {
        this(new PoolConfig(), hadoopConfiguration);
    }

    public HbaseConnectionPool(PoolConfig poolConfig, String host, String port) {
        this(poolConfig, host, port, HbaseConfig.DEFAULT_MASTER, HbaseConfig.DEFAULT_ROOTDIR);
    }

    public HbaseConnectionPool(PoolConfig poolConfig, Configuration hadoopConfiguration) {
        super(poolConfig, new HbaseConnectionFactory(hadoopConfiguration));
    }

    public HbaseConnectionPool(PoolConfig poolConfig, String host, String port, String master, String rootdir) {
        super(poolConfig, new HbaseConnectionFactory(host, port, master, rootdir));
    }

    public HbaseConnectionPool(PoolConfig poolConfig, Properties properties) {
        super(poolConfig, new HbaseConnectionFactory(properties));
    }

    @Override
    public Connection getConnection() {
        return (Connection)super.getResource();
    }

    @Override
    public void returnConnection(Connection conn) {
        super.returnResource(conn);
    }

    @Override
    public void invalidateConnection(Connection conn) {
        super.invalidateResource(conn);
    }
}

