/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.socket;

import java.net.Socket;
import java.util.Properties;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolBase;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.socket.SocketConfig;
import org.darkphoenixs.pool.socket.SocketConnectionFactory;

public class SocketConnectionPool
extends PoolBase<Socket>
implements ConnectionPool<Socket> {
    private static final long serialVersionUID = 4231761143726425981L;

    public SocketConnectionPool() {
        this(new PoolConfig(), "localhost", 1234);
    }

    public SocketConnectionPool(Properties properties) {
        this(new PoolConfig(), properties);
    }

    public SocketConnectionPool(PoolConfig poolConfig, Properties properties) {
        super(poolConfig, new SocketConnectionFactory(properties));
    }

    public SocketConnectionPool(PoolConfig poolConfig, String host, int port) {
        this(poolConfig, host, port, 3072, 2000);
    }

    public SocketConnectionPool(PoolConfig poolConfig, String host, int port, int bufferSize, int timeout) {
        this(poolConfig, host, port, bufferSize, timeout, 0);
    }

    public SocketConnectionPool(PoolConfig poolConfig, String host, int port, int bufferSize, int timeout, int linger) {
        this(poolConfig, host, port, bufferSize, timeout, linger, false, false);
    }

    public SocketConnectionPool(PoolConfig poolConfig, String host, int port, int bufferSize, int timeout, int linger, boolean keepAlive, boolean tcpNoDelay) {
        this(poolConfig, host, port, bufferSize, timeout, linger, keepAlive, tcpNoDelay, SocketConfig.DEFAULT_PERFORMANCE);
    }

    public SocketConnectionPool(PoolConfig poolConfig, String host, int port, int bufferSize, int timeout, int linger, boolean keepAlive, boolean tcpNoDelay, String[] performance) {
        super(poolConfig, new SocketConnectionFactory(host, port, bufferSize, bufferSize, timeout, timeout, linger, keepAlive, tcpNoDelay, performance));
    }

    @Override
    public Socket getConnection() {
        return (Socket)super.getResource();
    }

    @Override
    public void returnConnection(Socket conn) {
        super.returnResource(conn);
    }

    @Override
    public void invalidateConnection(Socket conn) {
        super.invalidateResource(conn);
    }
}

