/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.darkphoenixs.pool.ConnectionFactory;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolBase;
import org.darkphoenixs.pool.PoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.util.Hashing;

@Deprecated
public class RedisShardedConnPoolOld
extends PoolBase<ShardedJedis>
implements ConnectionPool<ShardedJedis> {
    private static final long serialVersionUID = -273019562990831722L;

    public RedisShardedConnPoolOld(PoolConfig poolConfig, List<JedisShardInfo> shards) {
        this(poolConfig, shards, Hashing.MURMUR_HASH);
    }

    public RedisShardedConnPoolOld(PoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo) {
        this(poolConfig, shards, algo, null);
    }

    public RedisShardedConnPoolOld(PoolConfig poolConfig, List<JedisShardInfo> shards, Pattern keyTagPattern) {
        this(poolConfig, shards, Hashing.MURMUR_HASH, keyTagPattern);
    }

    public RedisShardedConnPoolOld(PoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        this.initPool(poolConfig, new RedisShardedConnFactory(shards, algo, keyTagPattern));
    }

    @Override
    public ShardedJedis getConnection() {
        return (ShardedJedis)super.getResource();
    }

    @Override
    public void returnConnection(ShardedJedis conn) {
        boolean broken = false;
        for (Jedis jedis : conn.getAllShards()) {
            if (!jedis.getClient().isBroken()) continue;
            broken = true;
            break;
        }
        if (broken) {
            super.invalidateResource(conn);
        } else {
            super.returnResource(conn);
        }
    }

    @Override
    public void invalidateConnection(ShardedJedis conn) {
        super.invalidateResource(conn);
    }

    protected class RedisShardedConnFactory
    implements ConnectionFactory<ShardedJedis> {
        private static final long serialVersionUID = -8620587542840002906L;
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public RedisShardedConnFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        public PooledObject<ShardedJedis> makeObject() throws Exception {
            ShardedJedis jedis = this.createConnection();
            return new DefaultPooledObject((Object)jedis);
        }

        public void destroyObject(PooledObject<ShardedJedis> pooledShardedJedis) throws Exception {
            ShardedJedis shardedJedis = (ShardedJedis)pooledShardedJedis.getObject();
            for (Jedis jedis : shardedJedis.getAllShards()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception exception) {}
            }
        }

        public boolean validateObject(PooledObject<ShardedJedis> pooledShardedJedis) {
            try {
                ShardedJedis jedis = (ShardedJedis)pooledShardedJedis.getObject();
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void activateObject(PooledObject<ShardedJedis> p) throws Exception {
        }

        public void passivateObject(PooledObject<ShardedJedis> p) throws Exception {
        }

        @Override
        public ShardedJedis createConnection() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            return jedis;
        }
    }
}

