/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.redis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionPool;
import org.darkphoenixs.pool.PoolBase;
import org.darkphoenixs.pool.PoolConfig;
import org.darkphoenixs.pool.redis.RedisConfig;
import org.darkphoenixs.pool.redis.RedisConnectionFactoryOld;
import redis.clients.jedis.Client;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

@Deprecated
public class RedisSentinelConnPoolOld
extends PoolBase<Jedis>
implements ConnectionPool<Jedis> {
    private static final long serialVersionUID = -2917559115197092907L;
    protected String masterName;
    protected Set<String> sentinels;
    protected PoolConfig poolConfig;
    protected int connectionTimeout = 2000;
    protected int soTimeout = 2000;
    protected String password = RedisConfig.DEFAULT_PASSWORD;
    protected int database = 0;
    protected String clientName = RedisConfig.DEFAULT_CLIENTNAME;
    protected Set<RedisMasterListener> masterListeners = new HashSet<RedisMasterListener>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private volatile RedisConnectionFactoryOld factory;
    private volatile HostAndPort currentHostMaster;

    protected RedisSentinelConnPoolOld() {
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels) {
        this(masterName, sentinels, new PoolConfig());
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig) {
        this(masterName, sentinels, poolConfig, 2000);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int timeout) {
        this(masterName, sentinels, poolConfig, timeout, RedisConfig.DEFAULT_PASSWORD);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, String password) {
        this(masterName, sentinels, new PoolConfig(), password);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, String password) {
        this(masterName, sentinels, poolConfig, 2000, password);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int timeout, String password) {
        this(masterName, sentinels, poolConfig, timeout, password, 0);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int timeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, password, database, RedisConfig.DEFAULT_CLIENTNAME);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, password, database, clientName);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int timeout, int soTimeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, soTimeout, password, database, RedisConfig.DEFAULT_CLIENTNAME);
    }

    public RedisSentinelConnPoolOld(String masterName, Set<String> sentinels, PoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this.masterName = masterName;
        this.sentinels = sentinels;
        this.poolConfig = poolConfig;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
    }

    public RedisSentinelConnPoolOld(PoolConfig poolConfig, Properties properties) {
        this.poolConfig = poolConfig;
        if (null != properties.getProperty("connectionTimeout")) {
            this.connectionTimeout = Integer.parseInt(properties.getProperty("connectionTimeout"));
        }
        if (null != properties.getProperty("soTimeout")) {
            this.soTimeout = Integer.parseInt(properties.getProperty("soTimeout"));
        }
        if (null != properties.getProperty("database")) {
            this.database = Integer.parseInt(properties.getProperty("database"));
        }
        this.password = properties.getProperty("password");
        this.clientName = properties.getProperty("clientName");
        String masterName = properties.getProperty("masterName");
        if (masterName == null) {
            throw new ConnectionException("[masterName] is required !");
        }
        this.masterName = masterName;
        String sentinels = properties.getProperty("sentinels");
        if (sentinels == null) {
            throw new ConnectionException("[sentinels] is required !");
        }
        this.sentinels = new HashSet<String>(Arrays.asList(sentinels.split(",")));
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    public void init() {
        HostAndPort master = this.initSentinels(this.sentinels, this.masterName);
        this.initListeners(master, this.sentinels, this.masterName);
        this.initPool(master);
    }

    protected void initPool(HostAndPort master) {
        if (!master.equals((Object)this.currentHostMaster)) {
            this.currentHostMaster = master;
            if (this.factory == null) {
                this.factory = new RedisConnectionFactoryOld(master.getHost(), master.getPort(), this.connectionTimeout, this.soTimeout, this.password, this.database, this.clientName);
                this.initPool(this.poolConfig, this.factory);
            } else {
                this.factory.setHostAndPort(this.currentHostMaster);
                this.internalPool.clear();
            }
            this.log.info("Created JedisPool to master at " + master);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostAndPort initSentinels(Set<String> sentinels, String masterName) {
        HostAndPort master = null;
        boolean sentinelAvailable = false;
        this.log.info("Trying to find master from available Sentinels...");
        for (String sentinel : sentinels) {
            HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
            this.log.fine("Connecting to Sentinel " + hap);
            Jedis jedis = null;
            try {
                jedis = new Jedis(hap.getHost(), hap.getPort());
                List masterAddr = jedis.sentinelGetMasterAddrByName(masterName);
                sentinelAvailable = true;
                if (masterAddr == null || masterAddr.size() != 2) {
                    this.log.warning("Can not get master addr, master name: " + masterName + ". Sentinel: " + hap + ".");
                    continue;
                }
                master = this.toHostAndPort(masterAddr);
                this.log.fine("Found Redis master at " + master);
                break;
            }
            catch (Exception e) {
                this.log.warning("Cannot get master address from sentinel running @ " + hap + ". Reason: " + e + ". Trying next one.");
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        if (master == null) {
            if (sentinelAvailable) {
                throw new ConnectionException("Can connect to sentinel, but " + masterName + " seems to be not monitored...");
            }
            throw new ConnectionException("All sentinels down, cannot determine where is " + masterName + " master is running...");
        }
        return master;
    }

    protected void initListeners(HostAndPort master, Set<String> sentinels, String masterName) {
        this.log.info("Redis master running at " + master + ", starting Sentinel listeners...");
        for (String sentinel : sentinels) {
            HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
            RedisMasterListener masterListener = new RedisMasterListener(masterName, hap.getHost(), hap.getPort());
            masterListener.setDaemon(true);
            this.masterListeners.add(masterListener);
            masterListener.start();
        }
    }

    protected HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    @Override
    public Jedis getResource() {
        Jedis jedis;
        HostAndPort connection;
        HostAndPort master;
        while (!(master = this.currentHostMaster).equals((Object)(connection = new HostAndPort((jedis = (Jedis)super.getResource()).getClient().getHost(), jedis.getClient().getPort())))) {
            this.invalidateResource(jedis);
        }
        return jedis;
    }

    @Override
    public void destroy() {
        for (RedisMasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    @Override
    public Jedis getConnection() {
        return this.getResource();
    }

    @Override
    public void returnConnection(Jedis conn) {
        Client client = conn.getClient();
        if (client.isBroken()) {
            this.invalidateResource(conn);
        } else {
            this.returnResource(conn);
        }
    }

    @Override
    public void invalidateConnection(Jedis conn) {
        this.invalidateResource(conn);
    }

    protected class RedisMasterPubSub
    extends JedisPubSub {
        protected String masterName;
        protected String host;
        protected int port;

        protected RedisMasterPubSub() {
        }

        public RedisMasterPubSub(String masterName, String host, int port) {
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public void onMessage(String channel, String message) {
            RedisSentinelConnPoolOld.this.log.fine("Sentinel " + this.host + ":" + this.port + " published: " + message + ".");
            String[] switchMasterMsg = message.split(" ");
            if (switchMasterMsg.length > 3) {
                if (this.masterName.equals(switchMasterMsg[0])) {
                    RedisSentinelConnPoolOld.this.initPool(RedisSentinelConnPoolOld.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4])));
                } else {
                    RedisSentinelConnPoolOld.this.log.fine("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our master name is " + this.masterName);
                }
            } else {
                RedisSentinelConnPoolOld.this.log.severe("Invalid message received on Sentinel " + this.host + ":" + this.port + " on channel +switch-master: " + message);
            }
        }
    }

    protected class RedisMasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis;
        protected volatile Jedis j;
        protected AtomicBoolean running;

        protected RedisMasterListener() {
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
        }

        public RedisMasterListener(String masterName, String host, int port) {
            super(String.format("MasterListener-%s-[%s:%d]", masterName, host, port));
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public RedisMasterListener(String masterName, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masterName, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.j = new Jedis(this.host, this.port);
                try {
                    if (!this.running.get()) break;
                    this.j.subscribe((JedisPubSub)new RedisMasterPubSub(this.masterName, this.host, this.port), new String[]{"+switch-master"});
                }
                catch (Exception e) {
                    if (this.running.get()) {
                        RedisSentinelConnPoolOld.this.log.severe("Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.");
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    RedisSentinelConnPoolOld.this.log.fine("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
                finally {
                    this.j.close();
                }
            }
        }

        public void shutdown() {
            try {
                RedisSentinelConnPoolOld.this.log.fine("Shutting down listener on " + this.host + ":" + this.port);
                this.running.set(false);
                if (this.j != null) {
                    this.j.disconnect();
                }
            }
            catch (Exception e) {
                RedisSentinelConnPoolOld.this.log.log(Level.SEVERE, "Caught exception while shutting down: ", e);
            }
        }
    }
}

