/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.hbase;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionPool;

public class HbaseSharedConnPool
implements ConnectionPool<Connection> {
    private static final AtomicReference<HbaseSharedConnPool> pool = new AtomicReference();
    private final Connection connection;

    private HbaseSharedConnPool(Configuration configuration) throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)configuration);
    }

    public static synchronized HbaseSharedConnPool getInstance(String host, String port, String master, String rootdir) {
        Properties properties = new Properties();
        if (host == null) {
            throw new ConnectionException("[hbase.zookeeper.quorum] is required !");
        }
        properties.setProperty("hbase.zookeeper.quorum", host);
        if (port == null) {
            throw new ConnectionException("[hbase.zookeeper.property.clientPort] is required !");
        }
        properties.setProperty("hbase.zookeeper.property.clientPort", port);
        if (master != null) {
            properties.setProperty("hbase.master", master);
        }
        if (rootdir != null) {
            properties.setProperty("hbase.rootdir", rootdir);
        }
        return HbaseSharedConnPool.getInstance(properties);
    }

    public static synchronized HbaseSharedConnPool getInstance(Properties properties) {
        Configuration configuration = new Configuration();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            configuration.set((String)entry.getKey(), (String)entry.getValue());
        }
        return HbaseSharedConnPool.getInstance(configuration);
    }

    public static synchronized HbaseSharedConnPool getInstance(Configuration configuration) {
        if (pool.get() == null) {
            try {
                pool.set(new HbaseSharedConnPool(configuration));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return pool.get();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void returnConnection(Connection conn) {
    }

    @Override
    public void invalidateConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.connection.close();
            pool.set(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

