/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.pool.hbase;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.darkphoenixs.pool.ConnectionException;
import org.darkphoenixs.pool.ConnectionFactory;

class HbaseConnectionFactory
implements ConnectionFactory<Connection> {
    private static final long serialVersionUID = 4024923894283696465L;
    private final Configuration hadoopConfiguration;

    public HbaseConnectionFactory(Configuration hadoopConfiguration) {
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public HbaseConnectionFactory(String host, String port, String master, String rootdir) {
        this.hadoopConfiguration = new Configuration();
        if (host == null) {
            throw new ConnectionException("[hbase.zookeeper.quorum] is required !");
        }
        this.hadoopConfiguration.set("hbase.zookeeper.quorum", host);
        if (port == null) {
            throw new ConnectionException("[hbase.zookeeper.property.clientPort] is required !");
        }
        this.hadoopConfiguration.set("hbase.zookeeper.property.clientPort", port);
        if (master != null) {
            this.hadoopConfiguration.set("hbase.master", master);
        }
        if (rootdir != null) {
            this.hadoopConfiguration.set("hbase.rootdir", rootdir);
        }
    }

    public HbaseConnectionFactory(Properties properties) {
        this.hadoopConfiguration = new Configuration();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.hadoopConfiguration.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        Connection connection = this.createConnection();
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<Connection> p) throws Exception {
        Connection connection = (Connection)p.getObject();
        if (connection != null) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<Connection> p) {
        Connection connection = (Connection)p.getObject();
        if (connection != null) {
            return !connection.isAborted() && !connection.isClosed();
        }
        return false;
    }

    public void activateObject(PooledObject<Connection> p) throws Exception {
    }

    public void passivateObject(PooledObject<Connection> p) throws Exception {
    }

    @Override
    public Connection createConnection() throws Exception {
        Connection connection = org.apache.hadoop.hbase.client.ConnectionFactory.createConnection((Configuration)this.hadoopConfiguration);
        return connection;
    }
}

