(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'stately-stately-concurrency-js-legacy', 'stately-stately-common-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('stately-stately-concurrency-js-legacy'), require('stately-stately-common-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'stately-stately-collections-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'stately-stately-collections-js-legacy'.");
    }
    if (typeof this['stately-stately-concurrency-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'stately-stately-collections-js-legacy'. Its dependency 'stately-stately-concurrency-js-legacy' was not found. Please, check whether 'stately-stately-concurrency-js-legacy' is loaded prior to 'stately-stately-collections-js-legacy'.");
    }
    if (typeof this['stately-stately-common-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'stately-stately-collections-js-legacy'. Its dependency 'stately-stately-common-js-legacy' was not found. Please, check whether 'stately-stately-common-js-legacy' is loaded prior to 'stately-stately-collections-js-legacy'.");
    }
    root['stately-stately-collections-js-legacy'] = factory(typeof this['stately-stately-collections-js-legacy'] === 'undefined' ? {} : this['stately-stately-collections-js-legacy'], kotlin, this['stately-stately-concurrency-js-legacy'], this['stately-stately-common-js-legacy']);
  }
}(this, function (_, Kotlin, $module$stately_stately_concurrency_js_legacy, $module$stately_stately_common_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Unit = Kotlin.kotlin.Unit;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var get_value = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.get_value_tcdsr8$;
  var set_value = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.set_value_fmva18$;
  var freeze = $module$stately_stately_common_js_legacy.co.touchlab.stately.freeze_eoe559$;
  var get_value_0 = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.get_value_tj9aa6$;
  var set_value_0 = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.set_value_5mkqfe$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var AtomicReference = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.AtomicReference;
  var AtomicInt = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.AtomicInt;
  var Lock = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.Lock;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Array_0 = Array;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init;
  var MutableMap$MutableEntry = Kotlin.kotlin.collections.MutableMap.MutableEntry;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var HashSet_init = Kotlin.kotlin.collections.HashSet_init_ww73n8$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var MutableSet = Kotlin.kotlin.collections.MutableSet;
  var equals = Kotlin.equals;
  var numberToInt = Kotlin.numberToInt;
  var MutableMap = Kotlin.kotlin.collections.MutableMap;
  var hashCode = Kotlin.hashCode;
  var ConcurrentModificationException_init = Kotlin.kotlin.ConcurrentModificationException_init;
  var ensureNotNull = Kotlin.ensureNotNull;
  var MutableIterator = Kotlin.kotlin.collections.MutableIterator;
  var UnsupportedOperationException_init_0 = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var MutableListIterator = Kotlin.kotlin.collections.MutableListIterator;
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var AtomicBoolean = $module$stately_stately_concurrency_js_legacy.co.touchlab.stately.concurrency.AtomicBoolean;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var toString = Kotlin.toString;
  var MutableList = Kotlin.kotlin.collections.MutableList;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var Collection = Kotlin.kotlin.collections.Collection;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  SharedLinkedList.prototype = Object.create(AbstractSharedLinkedList.prototype);
  SharedLinkedList.prototype.constructor = SharedLinkedList;
  CopyOnIterateLinkedList.prototype = Object.create(AbstractSharedLinkedList.prototype);
  CopyOnIterateLinkedList.prototype.constructor = CopyOnIterateLinkedList;
  function frozenLinkedList(stableIterator) {
    if (stableIterator === void 0)
      stableIterator = false;
    if (stableIterator) {
      return new CopyOnIterateLinkedList();
    } else {
      return new SharedLinkedList();
    }
  }
  function frozenHashMap(initialCapacity, loadFactor) {
    if (initialCapacity === void 0)
      initialCapacity = 16;
    if (loadFactor === void 0)
      loadFactor = 0.75;
    return new SharedHashMap(initialCapacity, loadFactor);
  }
  function frozenHashSet() {
    return new SharedSet();
  }
  function frozenLruCache$lambda(it) {
    return Unit;
  }
  function frozenLruCache(maxCacheSize, onRemove) {
    if (onRemove === void 0)
      onRemove = frozenLruCache$lambda;
    return new SharedLruCache(maxCacheSize, onRemove);
  }
  function toList($receiver) {
    var result = ArrayList_init();
    while ($receiver.hasNext()) {
      result.add_11rb$($receiver.next());
    }
    return result;
  }
  function ObjectPool(maxSize, createBlock, cleanupBlock) {
    if (cleanupBlock === void 0)
      cleanupBlock = null;
    this.maxSize_0 = maxSize;
    this.createBlock_0 = createBlock;
    this.cleanupBlock_0 = cleanupBlock;
    if (this.maxSize_0 < 0) {
      throw IllegalArgumentException_init('maxSize cannot be negative');
    }
    var array = Array_0(this.maxSize_0);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = new AtomicReference(null);
    }
    this.pool_8be2vx$ = array;
    this.poolIndex_0 = new AtomicInt(0);
    this.lock_0 = new Lock();
  }
  ObjectPool.prototype.push_11rb$ = function (t) {
    var $receiver = this.lock_0;
    var withLock$result;
    $receiver.lock();
    try {
      var block$result;
      var tmp$, tmp$_0, tmp$_1;
      if (this.maxSize_0 === 0) {
        (tmp$ = this.cleanupBlock_0) != null ? tmp$(t) : null;
        block$result = false;
      } else {
        var index = get_value(this.poolIndex_0);
        if (index >= this.maxSize_0) {
          (tmp$_0 = this.cleanupBlock_0) != null ? tmp$_0(t) : null;
          tmp$_1 = false;
        } else {
          set_value(this.pool_8be2vx$[index], t);
          this.poolIndex_0.incrementAndGet();
          tmp$_1 = true;
        }
        return tmp$_1;
      }
      withLock$result = block$result;
    }finally {
      $receiver.unlock();
    }
    return withLock$result;
  };
  ObjectPool.prototype.pop = function () {
    var $receiver = this.lock_0;
    var withLock$result;
    $receiver.lock();
    try {
      var block$result;
      var tmp$;
      if (this.maxSize_0 === 0) {
        block$result = freeze(this.createBlock_0());
      } else {
        var index = get_value(this.poolIndex_0);
        if (index <= 0) {
          tmp$ = null;
        } else {
          var ref = this.pool_8be2vx$[this.poolIndex_0.decrementAndGet()];
          var t = get_value_0(ref);
          set_value(ref, null);
          tmp$ = t;
        }
        var fromPool = tmp$;
        block$result = fromPool != null ? fromPool : freeze(this.createBlock_0());
      }
      withLock$result = block$result;
    }finally {
      $receiver.unlock();
    }
    return withLock$result;
  };
  ObjectPool.prototype.clear = function () {
    var $receiver = this.lock_0;
    $receiver.lock();
    try {
      var $receiver_0 = this.pool_8be2vx$;
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver_0.length; ++tmp$) {
        var element = $receiver_0[tmp$];
        var tmp$_0;
        var t = get_value_0(element);
        if (t != null) {
          (tmp$_0 = this.cleanupBlock_0) != null ? tmp$_0(t) : null;
          set_value(element, null);
        }
      }
      set_value_0(this.poolIndex_0, 0);
    }finally {
      $receiver.unlock();
    }
  };
  ObjectPool.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ObjectPool',
    interfaces: []
  };
  function SharedHashMap(initialCapacity, loadFactor) {
    if (initialCapacity === void 0)
      initialCapacity = 16;
    if (loadFactor === void 0)
      loadFactor = 0.75;
    this.loadFactor = loadFactor;
    this.lock_0 = new Lock();
    this.threshold_0 = null;
    this.atomSize_0 = new AtomicInt(0);
    this.buckets_0 = null;
    var capacity = 1;
    while (capacity < initialCapacity)
      capacity = capacity << 1;
    this.threshold_0 = new AtomicInt(numberToInt(capacity * this.loadFactor));
    this.buckets_0 = new AtomicReference(this.makeBuckets_0(capacity));
    freeze(this);
  }
  function SharedHashMap$Entry(k, v) {
    this.k_0 = k;
    this.v_0 = v;
  }
  Object.defineProperty(SharedHashMap$Entry.prototype, 'key', {
    configurable: true,
    get: function () {
      return this.k_0;
    }
  });
  Object.defineProperty(SharedHashMap$Entry.prototype, 'value', {
    configurable: true,
    get: function () {
      return this.v_0;
    }
  });
  SharedHashMap$Entry.prototype.setValue_11rc$ = function (newValue) {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$Entry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Entry',
    interfaces: [MutableMap$MutableEntry]
  };
  SharedHashMap$Entry.prototype.component1_0 = function () {
    return this.k_0;
  };
  SharedHashMap$Entry.prototype.component2_0 = function () {
    return this.v_0;
  };
  SharedHashMap$Entry.prototype.copy_xwzc9p$ = function (k, v) {
    return new SharedHashMap$Entry(k === void 0 ? this.k_0 : k, v === void 0 ? this.v_0 : v);
  };
  SharedHashMap$Entry.prototype.toString = function () {
    return 'Entry(k=' + Kotlin.toString(this.k_0) + (', v=' + Kotlin.toString(this.v_0)) + ')';
  };
  SharedHashMap$Entry.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.k_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.v_0) | 0;
    return result;
  };
  SharedHashMap$Entry.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.k_0, other.k_0) && Kotlin.equals(this.v_0, other.v_0)))));
  };
  SharedHashMap.prototype.withLock_i3ch5z$ = defineInlineFunction('stately-stately-collections-js-legacy.co.touchlab.stately.collections.SharedHashMap.withLock_i3ch5z$', function (proc) {
    this.lock_0.lock();
    try {
      return proc();
    }finally {
      this.lock_0.unlock();
    }
  });
  SharedHashMap.prototype.makeBuckets_0 = function (capacity) {
    var array = Array_0(capacity);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = new AtomicReference(freeze(new SharedLinkedList(1)));
    }
    return freeze(array);
  };
  SharedHashMap.prototype.iterInternal_0 = function (proc) {
    var $receiver = get_value_0(this.buckets_0);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var element = $receiver[tmp$];
      var tmp$_0;
      tmp$_0 = get_value_0(element).iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        proc(element_0);
      }
    }
  };
  function SharedHashMap$get_SharedHashMap$entries$lambda(this$SharedHashMap) {
    return function () {
      var resultSet = HashSet_init(get_value(this$SharedHashMap.atomSize_0));
      var $receiver = get_value_0(this$SharedHashMap.buckets_0);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var element = $receiver[tmp$];
        var tmp$_0;
        tmp$_0 = get_value_0(element).iterator();
        while (tmp$_0.hasNext()) {
          var element_0 = tmp$_0.next();
          resultSet.add_11rb$(element_0);
        }
      }
      return new SharedHashMap$NotReallyMutableSet(resultSet);
    };
  }
  Object.defineProperty(SharedHashMap.prototype, 'entries', {
    configurable: true,
    get: function () {
      var withLock_i3ch5z$result;
      this.lock_0.lock();
      try {
        withLock_i3ch5z$result = SharedHashMap$get_SharedHashMap$entries$lambda(this)();
      }finally {
        this.lock_0.unlock();
      }
      return withLock_i3ch5z$result;
    }
  });
  function SharedHashMap$get_SharedHashMap$keys$lambda(this$SharedHashMap) {
    return function () {
      var keySet = HashSet_init(get_value(this$SharedHashMap.atomSize_0));
      var $receiver = get_value_0(this$SharedHashMap.buckets_0);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var element = $receiver[tmp$];
        var tmp$_0;
        tmp$_0 = get_value_0(element).iterator();
        while (tmp$_0.hasNext()) {
          var element_0 = tmp$_0.next();
          keySet.add_11rb$(element_0.key);
        }
      }
      return new SharedHashMap$NotReallyMutableSet(keySet);
    };
  }
  Object.defineProperty(SharedHashMap.prototype, 'keys', {
    configurable: true,
    get: function () {
      var withLock_i3ch5z$result;
      this.lock_0.lock();
      try {
        withLock_i3ch5z$result = SharedHashMap$get_SharedHashMap$keys$lambda(this)();
      }finally {
        this.lock_0.unlock();
      }
      return withLock_i3ch5z$result;
    }
  });
  function SharedHashMap$get_SharedHashMap$values$lambda(this$SharedHashMap) {
    return function () {
      var result = ArrayList_init_0(get_value(this$SharedHashMap.atomSize_0));
      var $receiver = get_value_0(this$SharedHashMap.buckets_0);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var element = $receiver[tmp$];
        var tmp$_0;
        tmp$_0 = get_value_0(element).iterator();
        while (tmp$_0.hasNext()) {
          var element_0 = tmp$_0.next();
          result.add_11rb$(element_0.value);
        }
      }
      return new SharedHashMap$NotReallyMutableSet(result);
    };
  }
  Object.defineProperty(SharedHashMap.prototype, 'values', {
    configurable: true,
    get: function () {
      var withLock_i3ch5z$result;
      this.lock_0.lock();
      try {
        withLock_i3ch5z$result = SharedHashMap$get_SharedHashMap$values$lambda(this)();
      }finally {
        this.lock_0.unlock();
      }
      return withLock_i3ch5z$result;
    }
  });
  function SharedHashMap$NotReallyMutableSet(delegate) {
    this.delegate_0 = delegate;
  }
  SharedHashMap$NotReallyMutableSet.prototype.add_11rb$ = function (element) {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$NotReallyMutableSet.prototype.addAll_brywnq$ = function (elements) {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$NotReallyMutableSet.prototype.clear = function () {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$NotReallyMutableSet.prototype.iterator = function () {
    return this.delegate_0.iterator();
  };
  SharedHashMap$NotReallyMutableSet.prototype.remove_11rb$ = function (element) {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$NotReallyMutableSet.prototype.removeAll_brywnq$ = function (elements) {
    throw UnsupportedOperationException_init();
  };
  SharedHashMap$NotReallyMutableSet.prototype.retainAll_brywnq$ = function (elements) {
    throw UnsupportedOperationException_init();
  };
  Object.defineProperty(SharedHashMap$NotReallyMutableSet.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.delegate_0.size;
    }
  });
  SharedHashMap$NotReallyMutableSet.prototype.contains_11rb$ = function (element) {
    return this.delegate_0.contains_11rb$(element);
  };
  SharedHashMap$NotReallyMutableSet.prototype.containsAll_brywnq$ = function (elements) {
    return this.delegate_0.containsAll_brywnq$(elements);
  };
  SharedHashMap$NotReallyMutableSet.prototype.isEmpty = function () {
    return this.delegate_0.isEmpty();
  };
  SharedHashMap$NotReallyMutableSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NotReallyMutableSet',
    interfaces: [MutableSet]
  };
  function SharedHashMap$clear$lambda(this$SharedHashMap) {
    return function () {
      var $receiver = get_value_0(this$SharedHashMap.buckets_0);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var element = $receiver[tmp$];
        get_value_0(element).clear();
      }
      set_value_0(this$SharedHashMap.atomSize_0, 0);
      return Unit;
    };
  }
  SharedHashMap.prototype.clear = function () {
    this.lock_0.lock();
    try {
      SharedHashMap$clear$lambda(this)();
    }finally {
      this.lock_0.unlock();
    }
  };
  SharedHashMap.prototype.containsKey_11rb$ = function (key) {
    return this.get_11rb$(key) != null;
  };
  function SharedHashMap$containsValue$lambda(closure$value, this$SharedHashMap) {
    return function () {
      var $this = this$SharedHashMap;
      var $receiver = get_value_0($this.buckets_0);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var element = $receiver[tmp$];
        var tmp$_0;
        tmp$_0 = get_value_0(element).iterator();
        while (tmp$_0.hasNext()) {
          var element_0 = tmp$_0.next();
          var closure$value_0 = closure$value;
          if (equals(element_0.value, closure$value_0)) {
            return true;
          }
        }
      }
      return false;
    };
  }
  SharedHashMap.prototype.containsValue_11rc$ = function (value) {
    var withLock_i3ch5z$result;
    this.lock_0.lock();
    try {
      withLock_i3ch5z$result = SharedHashMap$containsValue$lambda(value, this)();
    }finally {
      this.lock_0.unlock();
    }
    return withLock_i3ch5z$result;
  };
  function SharedHashMap$get$lambda(this$SharedHashMap, closure$key) {
    return function () {
      var entryList = this$SharedHashMap.findEntryList_0(get_value_0(this$SharedHashMap.buckets_0), closure$key);
      var tmp$;
      tmp$ = entryList.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var closure$key_0 = closure$key;
        if (equals(element.key, closure$key_0)) {
          return element.value;
        }
      }
      return null;
    };
  }
  SharedHashMap.prototype.get_11rb$ = function (key) {
    var withLock_i3ch5z$result;
    this.lock_0.lock();
    try {
      withLock_i3ch5z$result = SharedHashMap$get$lambda(this, key)();
    }finally {
      this.lock_0.unlock();
    }
    return withLock_i3ch5z$result;
  };
  SharedHashMap.prototype.isEmpty = function () {
    return get_value(this.atomSize_0) === 0;
  };
  function SharedHashMap$put$lambda(closure$key, closure$value, this$SharedHashMap) {
    return function () {
      return this$SharedHashMap.internalPut_0(closure$key, closure$value);
    };
  }
  SharedHashMap.prototype.put_xwzc9p$ = function (key, value) {
    var withLock_i3ch5z$result;
    this.lock_0.lock();
    try {
      withLock_i3ch5z$result = SharedHashMap$put$lambda(key, value, this)();
    }finally {
      this.lock_0.unlock();
    }
    return withLock_i3ch5z$result;
  };
  function SharedHashMap$putAll$lambda(closure$from, this$SharedHashMap) {
    return function () {
      var $receiver = closure$from.entries;
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this$SharedHashMap.internalPut_0(element.key, element.value);
      }
      return Unit;
    };
  }
  SharedHashMap.prototype.putAll_a2k3zr$ = function (from) {
    this.lock_0.lock();
    try {
      SharedHashMap$putAll$lambda(from, this)();
    }finally {
      this.lock_0.unlock();
    }
  };
  function SharedHashMap$remove$lambda(this$SharedHashMap, closure$key) {
    return function () {
      var entryList = this$SharedHashMap.findEntryList_0(get_value_0(this$SharedHashMap.buckets_0), closure$key);
      var result = this$SharedHashMap.internalRemoveByKey_0(entryList, closure$key);
      return result;
    };
  }
  SharedHashMap.prototype.remove_11rb$ = function (key) {
    var withLock_i3ch5z$result;
    this.lock_0.lock();
    try {
      withLock_i3ch5z$result = SharedHashMap$remove$lambda(this, key)();
    }finally {
      this.lock_0.unlock();
    }
    return withLock_i3ch5z$result;
  };
  SharedHashMap.prototype.internalRemoveByKey_0 = function (entryList, key) {
    var result = null;
    var iter = entryList.nodeIterator();
    while (iter.hasNext()) {
      var it = iter.next();
      if (equals(it.nodeValue.key, key)) {
        result = it;
        break;
      }
    }
    if (result != null) {
      var ret = result.nodeValue.value;
      result.remove_6taknv$();
      this.atomSize_0.decrementAndGet();
      return ret;
    }
    return result;
  };
  Object.defineProperty(SharedHashMap.prototype, 'size', {
    configurable: true,
    get: function () {
      return get_value(this.atomSize_0);
    }
  });
  SharedHashMap.prototype.internalPut_0 = function (key, value) {
    var entryList = this.findEntryList_0(get_value_0(this.buckets_0), key);
    var result = this.internalRemoveByKey_0(entryList, key);
    entryList.add_11rb$(freeze(new SharedHashMap$Entry(key, value)));
    this.atomSize_0.incrementAndGet();
    if (get_value(this.atomSize_0) > get_value(this.threshold_0)) {
      this.resize_0(2 * get_value_0(this.buckets_0).length | 0);
    }
    return result;
  };
  SharedHashMap.prototype.resize_0 = function (newCapacity) {
    var oldTable = get_value_0(this.buckets_0);
    var newTable = this.makeBuckets_0(newCapacity);
    this.transfer_0(newTable, oldTable);
    set_value(this.buckets_0, newTable);
    set_value_0(this.threshold_0, numberToInt(newCapacity * this.loadFactor));
  };
  SharedHashMap.prototype.transfer_0 = function (newTable, oldTable) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== oldTable.length; ++tmp$) {
      var element = oldTable[tmp$];
      var $receiver = get_value_0(element).iterator();
      while ($receiver.hasNext()) {
        var element_0 = $receiver.next();
        this.findEntryList_0(newTable, element_0.key).add_11rb$(element_0);
      }
      get_value_0(element).clear();
    }
  };
  SharedHashMap.prototype.currentBucketSize_8be2vx$ = function () {
    return get_value_0(this.buckets_0).length;
  };
  SharedHashMap.prototype.indexFor_0 = function (h, length) {
    return h & length - 1;
  };
  SharedHashMap.prototype.rehash_kcn2v3$ = function (initHash) {
    var h = initHash;
    h = h ^ (h >>> 20 ^ h >>> 12);
    return h ^ h >>> 7 ^ h >>> 4;
  };
  SharedHashMap.prototype.findEntryList_0 = function (bucketArray, key) {
    var tmp$;
    var hash = this.rehash_kcn2v3$((tmp$ = key != null ? hashCode(key) : null) != null ? tmp$ : 0);
    var entryList = get_value_0(bucketArray[this.indexFor_0(hash, bucketArray.length)]);
    return entryList;
  };
  SharedHashMap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SharedHashMap',
    interfaces: [MutableMap]
  };
  function SharedLinkedList(objectPoolSize) {
    if (objectPoolSize === void 0)
      objectPoolSize = 0;
    AbstractSharedLinkedList.call(this, objectPoolSize);
    this.version_8be2vx$ = new AtomicInt(0);
    freeze(this);
  }
  SharedLinkedList.prototype.updated = function () {
    var newVal = this.version_8be2vx$.incrementAndGet();
    if (newVal === 2147483647) {
      this.version_8be2vx$.set_za3lpa$(0);
    }
  };
  SharedLinkedList.prototype.listIterator = function () {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  };
  SharedLinkedList.prototype.listIterator_za3lpa$ = function (index) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  };
  SharedLinkedList.prototype.iterator = function () {
    return new SharedLinkedList$LLIterator(this, get_value(this.version_8be2vx$));
  };
  SharedLinkedList.prototype.nodeIterator = function () {
    return new SharedLinkedList$NodeIterator(this, get_value(this.version_8be2vx$));
  };
  function SharedLinkedList$NodeIterator(ll, version) {
    this.ll_0 = ll;
    this.version_0 = version;
    this.currentNode = get_value_0(this.ll_0.head_8be2vx$);
  }
  SharedLinkedList$NodeIterator.prototype.remove = function () {
    throw UnsupportedOperationException_init();
  };
  SharedLinkedList$NodeIterator.prototype.checkVersion_0 = function () {
    if (this.version_0 !== this.ll_0.version_8be2vx$.get()) {
      throw ConcurrentModificationException_init();
    }
  };
  SharedLinkedList$NodeIterator.prototype.hasNext = function () {
    this.checkVersion_0();
    return this.currentNode != null;
  };
  SharedLinkedList$NodeIterator.prototype.next = function () {
    var tmp$, tmp$_0;
    this.checkVersion_0();
    var retval = ensureNotNull(this.currentNode);
    this.currentNode = (tmp$_0 = (tmp$ = this.currentNode) != null ? tmp$.next : null) != null ? get_value_0(tmp$_0) : null;
    return retval;
  };
  SharedLinkedList$NodeIterator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NodeIterator',
    interfaces: [MutableIterator]
  };
  function SharedLinkedList$LLIterator(ll, version) {
    this.ll_0 = ll;
    this.version_0 = version;
    this.currentNode = get_value_0(this.ll_0.head_8be2vx$);
  }
  SharedLinkedList$LLIterator.prototype.remove = function () {
    throw UnsupportedOperationException_init();
  };
  SharedLinkedList$LLIterator.prototype.checkVersion_0 = function () {
    if (this.version_0 !== this.ll_0.version_8be2vx$.get()) {
      throw ConcurrentModificationException_init();
    }
  };
  SharedLinkedList$LLIterator.prototype.hasNext = function () {
    var tmp$;
    this.checkVersion_0();
    return ((tmp$ = this.currentNode) != null ? tmp$.nodeValue : null) != null;
  };
  SharedLinkedList$LLIterator.prototype.next = function () {
    var tmp$, tmp$_0, tmp$_1;
    this.checkVersion_0();
    var retval;
    retval = ensureNotNull((tmp$ = this.currentNode) != null ? tmp$.nodeValue : null);
    this.currentNode = (tmp$_1 = (tmp$_0 = this.currentNode) != null ? tmp$_0.next : null) != null ? get_value_0(tmp$_1) : null;
    return retval;
  };
  SharedLinkedList$LLIterator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LLIterator',
    interfaces: [MutableIterator]
  };
  SharedLinkedList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SharedLinkedList',
    interfaces: [AbstractSharedLinkedList]
  };
  function CopyOnIterateLinkedList(objectPoolSize) {
    if (objectPoolSize === void 0)
      objectPoolSize = 0;
    AbstractSharedLinkedList.call(this, objectPoolSize);
    this.updated_0 = null;
    this.lastList_0 = null;
    this.updated_0 = new AtomicInt(0);
    this.lastList_0 = new AtomicReference(freeze(ArrayList_init()));
    freeze(this);
  }
  CopyOnIterateLinkedList.prototype.updated = function () {
    set_value_0(this.updated_0, 1);
  };
  function CopyOnIterateLinkedList$iterator$lambda(this$CopyOnIterateLinkedList) {
    return function () {
      return this$CopyOnIterateLinkedList.checkUpdate_0();
    };
  }
  CopyOnIterateLinkedList.prototype.iterator = function () {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = CopyOnIterateLinkedList$iterator$lambda(this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return new LocalIterator(withLock_50n1m8$result.iterator());
  };
  function CopyOnIterateLinkedList$listIterator$lambda(this$CopyOnIterateLinkedList) {
    return function () {
      return this$CopyOnIterateLinkedList.checkUpdate_0();
    };
  }
  CopyOnIterateLinkedList.prototype.listIterator = function () {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = CopyOnIterateLinkedList$listIterator$lambda(this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return new LocalListIterator(withLock_50n1m8$result.listIterator());
  };
  function CopyOnIterateLinkedList$listIterator$lambda_0(this$CopyOnIterateLinkedList) {
    return function () {
      return this$CopyOnIterateLinkedList.checkUpdate_0();
    };
  }
  CopyOnIterateLinkedList.prototype.listIterator_za3lpa$ = function (index) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = CopyOnIterateLinkedList$listIterator$lambda_0(this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return new LocalListIterator(withLock_50n1m8$result.listIterator_za3lpa$(index));
  };
  CopyOnIterateLinkedList.prototype.checkUpdate_0 = function () {
    if (get_value(this.updated_0) !== 0) {
      var newList = ArrayList_init_0(get_value(this.sizeCount_8be2vx$));
      var node = get_value_0(this.head_8be2vx$);
      var nodeCount = 0;
      while (node != null) {
        newList.add_11rb$(node.nodeValue);
        node = get_value_0(node.next);
        nodeCount = nodeCount + 1 | 0;
      }
      set_value_0(this.updated_0, 0);
      set_value(this.lastList_0, freeze(newList));
    }
    return get_value_0(this.lastList_0);
  };
  CopyOnIterateLinkedList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CopyOnIterateLinkedList',
    interfaces: [AbstractSharedLinkedList]
  };
  function LocalIterator(delegate) {
    this.delegate_0 = delegate;
  }
  LocalIterator.prototype.hasNext = function () {
    return this.delegate_0.hasNext();
  };
  LocalIterator.prototype.next = function () {
    return this.delegate_0.next();
  };
  LocalIterator.prototype.remove = function () {
    throw UnsupportedOperationException_init_0("Can't mutate list from iterator");
  };
  LocalIterator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LocalIterator',
    interfaces: [MutableIterator]
  };
  function LocalListIterator(delegate) {
    this.delegate_0 = delegate;
  }
  LocalListIterator.prototype.hasNext = function () {
    return this.delegate_0.hasNext();
  };
  LocalListIterator.prototype.next = function () {
    return this.delegate_0.next();
  };
  LocalListIterator.prototype.remove = function () {
    throw UnsupportedOperationException_init_0("Can't mutate list from iterator");
  };
  LocalListIterator.prototype.hasPrevious = function () {
    return this.delegate_0.hasPrevious();
  };
  LocalListIterator.prototype.nextIndex = function () {
    return this.delegate_0.nextIndex();
  };
  LocalListIterator.prototype.previous = function () {
    return this.delegate_0.previous();
  };
  LocalListIterator.prototype.previousIndex = function () {
    return this.delegate_0.previousIndex();
  };
  LocalListIterator.prototype.add_11rb$ = function (element) {
    throw UnsupportedOperationException_init();
  };
  LocalListIterator.prototype.set_11rb$ = function (element) {
    throw UnsupportedOperationException_init();
  };
  LocalListIterator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LocalListIterator',
    interfaces: [MutableListIterator]
  };
  function AbstractSharedLinkedList(objectPoolSize) {
    this.lock_8uoc56$_0 = new Lock();
    this.sizeCount_8be2vx$ = new AtomicInt(0);
    this.head_8be2vx$ = new AtomicReference(null);
    this.tail_8be2vx$ = new AtomicReference(null);
    this.nodePool_8be2vx$ = new ObjectPool(objectPoolSize, AbstractSharedLinkedList$nodePool$lambda(this));
  }
  function AbstractSharedLinkedList$lastIndexOf$lambda(this$AbstractSharedLinkedList, closure$element) {
    return function () {
      var lastIndex = -1;
      var indexCounter = 0;
      var currentNode = get_value_0(this$AbstractSharedLinkedList.head_8be2vx$);
      while (currentNode != null) {
        if (equals(currentNode.nodeValue, closure$element)) {
          lastIndex = indexCounter;
        }
        indexCounter = indexCounter + 1 | 0;
        currentNode = get_value_0(currentNode.next);
      }
      return lastIndex;
    };
  }
  AbstractSharedLinkedList.prototype.lastIndexOf_11rb$ = function (element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$lastIndexOf$lambda(this, element)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$retainAll$lambda(this$AbstractSharedLinkedList, closure$elements) {
    return function () {
      var result = ArrayList_init_0(get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$));
      var currentNode = get_value_0(this$AbstractSharedLinkedList.head_8be2vx$);
      while (currentNode != null) {
        var entry = currentNode.nodeValue;
        if (closure$elements.contains_11rb$(entry)) {
          result.add_11rb$(entry);
        }
        currentNode = get_value_0(currentNode.next);
      }
      this$AbstractSharedLinkedList.internalClear_i0oprn$_0();
      var tmp$;
      tmp$ = result.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var this$AbstractSharedLinkedList_0 = this$AbstractSharedLinkedList;
        this$AbstractSharedLinkedList_0.internalAdd_w85adh$(this$AbstractSharedLinkedList_0.makeNode_1c3m6u$(element));
      }
      return true;
    };
  }
  AbstractSharedLinkedList.prototype.retainAll_brywnq$ = function (elements) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$retainAll$lambda(this, elements)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  AbstractSharedLinkedList.prototype.subList_vux9f0$ = function (fromIndex, toIndex) {
    throw UnsupportedOperationException_init();
  };
  function AbstractSharedLinkedList$get_AbstractSharedLinkedList$size$lambda(this$AbstractSharedLinkedList) {
    return function () {
      return get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$);
    };
  }
  Object.defineProperty(AbstractSharedLinkedList.prototype, 'size', {
    configurable: true,
    get: function () {
      var withLock_50n1m8$result;
      this.lock_8be2vx$();
      try {
        withLock_50n1m8$result = AbstractSharedLinkedList$get_AbstractSharedLinkedList$size$lambda(this)();
      }finally {
        if (false) {
          this.updated();
        }
        this.unlock_8be2vx$();
      }
      return withLock_50n1m8$result;
    }
  });
  function AbstractSharedLinkedList$add$lambda(closure$element, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalAdd_w85adh$(this$AbstractSharedLinkedList.makeNode_1c3m6u$(closure$element));
    };
  }
  AbstractSharedLinkedList.prototype.add_11rb$ = function (element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$add$lambda(element, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$add$lambda_0(closure$index, this$AbstractSharedLinkedList, closure$element) {
    return function () {
      if (closure$index === get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$)) {
        return this$AbstractSharedLinkedList.internalAdd_w85adh$(this$AbstractSharedLinkedList.makeNode_1c3m6u$(closure$element));
      } else {
        return this$AbstractSharedLinkedList.internalNodeAt_kcn2v3$(closure$index).internalAdd_1c3m6u$(closure$element);
      }
    };
  }
  AbstractSharedLinkedList.prototype.add_wxm5ur$ = function (index, element) {
    this.lock_8be2vx$();
    try {
      AbstractSharedLinkedList$add$lambda_0(index, this, element)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
  };
  function AbstractSharedLinkedList$addNode$lambda(closure$element, this$AbstractSharedLinkedList) {
    return function () {
      var node = this$AbstractSharedLinkedList.makeNode_1c3m6u$(closure$element);
      this$AbstractSharedLinkedList.internalAdd_w85adh$(node);
      return node;
    };
  }
  AbstractSharedLinkedList.prototype.addNode_11rb$ = function (element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$addNode$lambda(element, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$addAll$lambda(closure$elements, this$AbstractSharedLinkedList, closure$index) {
    return function () {
      var tmp$;
      if (closure$index === get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$))
        tmp$ = this$AbstractSharedLinkedList.internalAddAll_eqrwgj$(closure$elements);
      else if (closure$index > get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$))
        throw new IndexOutOfBoundsException('Index ' + closure$index + ' > ' + get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$));
      else {
        var node = this$AbstractSharedLinkedList.internalNodeAt_kcn2v3$(closure$index);
        var tmp$_0;
        tmp$_0 = closure$elements.iterator();
        while (tmp$_0.hasNext()) {
          var element = tmp$_0.next();
          node.internalAdd_1c3m6u$(element);
        }
        tmp$ = true;
      }
      return tmp$;
    };
  }
  AbstractSharedLinkedList.prototype.addAll_u57x28$ = function (index, elements) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$addAll$lambda(elements, this, index)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$addAll$lambda_0(closure$elements, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalAddAll_eqrwgj$(closure$elements);
    };
  }
  AbstractSharedLinkedList.prototype.addAll_brywnq$ = function (elements) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$addAll$lambda_0(elements, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$clear$lambda(this$AbstractSharedLinkedList) {
    return function () {
      this$AbstractSharedLinkedList.internalClear_i0oprn$_0();
      return Unit;
    };
  }
  AbstractSharedLinkedList.prototype.clear = function () {
    this.lock_8be2vx$();
    try {
      AbstractSharedLinkedList$clear$lambda(this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
  };
  AbstractSharedLinkedList.prototype.internalClear_i0oprn$_0 = function () {
    while (get_value(this.sizeCount_8be2vx$) !== 0) {
      this.internalRemoveAt_kcn2v3$(0);
    }
    set_value(this.head_8be2vx$, null);
    set_value(this.tail_8be2vx$, null);
    set_value_0(this.sizeCount_8be2vx$, 0);
    this.nodePool_8be2vx$.clear();
  };
  function AbstractSharedLinkedList$contains$lambda(closure$element, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalFindFirst_1c3m6u$(closure$element) != null;
    };
  }
  AbstractSharedLinkedList.prototype.contains_11rb$ = function (element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$contains$lambda(element, this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$containsAll$lambda(closure$elements, this$AbstractSharedLinkedList) {
    return function () {
      var $receiver = closure$elements;
      var all$result;
      all$break: do {
        var tmp$;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          all$result = true;
          break all$break;
        }
        tmp$ = $receiver.iterator();
        while (tmp$.hasNext()) {
          var element = tmp$.next();
          if (!(this$AbstractSharedLinkedList.internalFindFirst_1c3m6u$(element) != null)) {
            all$result = false;
            break all$break;
          }
        }
        all$result = true;
      }
       while (false);
      return all$result;
    };
  }
  AbstractSharedLinkedList.prototype.containsAll_brywnq$ = function (elements) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$containsAll$lambda(elements, this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$get$lambda(closure$index, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalNodeAt_kcn2v3$(closure$index).nodeValue;
    };
  }
  AbstractSharedLinkedList.prototype.get_za3lpa$ = function (index) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$get$lambda(index, this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$indexOf$lambda(closure$element, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalFindFirstIndex_1c3m6u$(closure$element).index;
    };
  }
  AbstractSharedLinkedList.prototype.indexOf_11rb$ = function (element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$indexOf$lambda(element, this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$isEmpty$lambda(this$AbstractSharedLinkedList) {
    return function () {
      return get_value(this$AbstractSharedLinkedList.sizeCount_8be2vx$) === 0;
    };
  }
  AbstractSharedLinkedList.prototype.isEmpty = function () {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$isEmpty$lambda(this)();
    }finally {
      if (false) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$remove$lambda(closure$value, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalRemove_1c3m6u$(closure$value);
    };
  }
  AbstractSharedLinkedList.prototype.remove_11rb$ = function (value) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$remove$lambda(value, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$removeAll$lambda(closure$elements, this$AbstractSharedLinkedList) {
    return function () {
      var $receiver = closure$elements;
      var all$result;
      all$break: do {
        var tmp$;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          all$result = true;
          break all$break;
        }
        tmp$ = $receiver.iterator();
        while (tmp$.hasNext()) {
          var element = tmp$.next();
          if (!this$AbstractSharedLinkedList.internalRemove_1c3m6u$(element)) {
            all$result = false;
            break all$break;
          }
        }
        all$result = true;
      }
       while (false);
      return all$result;
    };
  }
  AbstractSharedLinkedList.prototype.removeAll_brywnq$ = function (elements) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$removeAll$lambda(elements, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$removeAt$lambda(closure$index, this$AbstractSharedLinkedList) {
    return function () {
      return this$AbstractSharedLinkedList.internalRemoveAt_kcn2v3$(closure$index);
    };
  }
  AbstractSharedLinkedList.prototype.removeAt_za3lpa$ = function (index) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$removeAt$lambda(index, this)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$set$lambda(closure$index, this$AbstractSharedLinkedList, closure$element) {
    return function () {
      var node = this$AbstractSharedLinkedList.internalNodeAt_kcn2v3$(closure$index);
      var old = node.nodeValue;
      node.internalSet_1c3m6u$(closure$element);
      return old;
    };
  }
  AbstractSharedLinkedList.prototype.set_wxm5ur$ = function (index, element) {
    var withLock_50n1m8$result;
    this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$set$lambda(index, this, element)();
    }finally {
      if (true) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  function AbstractSharedLinkedList$Node(list) {
    this.list = list;
    this.atomicValue_0 = new AtomicReference(null);
    this.prev = new AtomicReference(null);
    this.next = new AtomicReference(null);
    this.removed_0 = new AtomicBoolean(false);
  }
  Object.defineProperty(AbstractSharedLinkedList$Node.prototype, 'nodeValue', {
    configurable: true,
    get: function () {
      return ensureNotNull(get_value_0(this.atomicValue_0));
    }
  });
  AbstractSharedLinkedList$Node.prototype.recycle_8be2vx$ = function () {
    set_value(this.prev, null);
    set_value(this.next, null);
    this.removed_0.value = false;
  };
  AbstractSharedLinkedList$Node.prototype.clearValue_8be2vx$ = function () {
    set_value(this.atomicValue_0, null);
  };
  function AbstractSharedLinkedList$Node$set$lambda(closure$t, this$Node) {
    return function () {
      this$Node.internalSet_1c3m6u$(closure$t);
      return Unit;
    };
  }
  AbstractSharedLinkedList$Node.prototype.set_11rb$ = function (t) {
    var $this = this.list;
    $this.lock_8be2vx$();
    try {
      AbstractSharedLinkedList$Node$set$lambda(t, this)();
    }finally {
      if (true) {
        $this.updated();
      }
      $this.unlock_8be2vx$();
    }
  };
  AbstractSharedLinkedList$Node.prototype.internalSet_1c3m6u$ = function (t) {
    this.checkNotRemoved_8be2vx$();
    set_value(this.atomicValue_0, freeze(t));
  };
  function AbstractSharedLinkedList$Node$add$lambda(closure$t, this$Node) {
    return function () {
      return this$Node.internalAdd_1c3m6u$(closure$t);
    };
  }
  AbstractSharedLinkedList$Node.prototype.add_11rb$ = function (t) {
    var $this = this.list;
    var withLock_50n1m8$result;
    $this.lock_8be2vx$();
    try {
      withLock_50n1m8$result = AbstractSharedLinkedList$Node$add$lambda(t, this)();
    }finally {
      if (true) {
        $this.updated();
      }
      $this.unlock_8be2vx$();
    }
    return withLock_50n1m8$result;
  };
  AbstractSharedLinkedList$Node.prototype.internalAdd_1c3m6u$ = function (t) {
    this.checkNotRemoved_8be2vx$();
    var ins = this.list.makeNode_1c3m6u$(t);
    freeze(ins);
    var prevNode = get_value_0(this.prev);
    set_value(ins.prev, prevNode);
    set_value(ins.next, this);
    this.list.sizeCount_8be2vx$.incrementAndGet();
    if (prevNode == null) {
      set_value(this.list.head_8be2vx$, ins);
    } else {
      set_value(prevNode.next, ins);
    }
    set_value(this.prev, ins);
    return true;
  };
  AbstractSharedLinkedList$Node.prototype.checkNotRemoved_8be2vx$ = function () {
    if (this.removed_0.value) {
      throw IllegalStateException_init('Node is removed ' + this);
    }
  };
  function AbstractSharedLinkedList$Node$readd$lambda(this$Node) {
    return function () {
      this$Node.internalReadd_8be2vx$();
      return Unit;
    };
  }
  AbstractSharedLinkedList$Node.prototype.readd = function () {
    var $this = this.list;
    $this.lock_8be2vx$();
    try {
      AbstractSharedLinkedList$Node$readd$lambda(this)();
    }finally {
      if (true) {
        $this.updated();
      }
      $this.unlock_8be2vx$();
    }
  };
  AbstractSharedLinkedList$Node.prototype.internalReadd_8be2vx$ = function () {
    this.checkNotRemoved_8be2vx$();
    this.internalRemove_vft4zs$(false);
    set_value(this.prev, null);
    set_value(this.next, null);
    this.list.internalAdd_w85adh$(this);
  };
  function AbstractSharedLinkedList$Node$remove$lambda(closure$permanent, this$Node) {
    return function () {
      this$Node.internalRemove_vft4zs$(closure$permanent);
      return Unit;
    };
  }
  AbstractSharedLinkedList$Node.prototype.remove_6taknv$ = function (permanent) {
    if (permanent === void 0)
      permanent = true;
    var $this = this.list;
    $this.lock_8be2vx$();
    try {
      AbstractSharedLinkedList$Node$remove$lambda(permanent, this)();
    }finally {
      if (true) {
        $this.updated();
      }
      $this.unlock_8be2vx$();
    }
  };
  Object.defineProperty(AbstractSharedLinkedList$Node.prototype, 'isRemoved', {
    configurable: true,
    get: function () {
      return this.removed_0.value;
    }
  });
  AbstractSharedLinkedList$Node.prototype.internalRemove_vft4zs$ = function (permanent) {
    if (permanent === void 0)
      permanent = true;
    this.checkNotRemoved_8be2vx$();
    if (permanent) {
      this.removed_0.value = true;
      this.clearValue_8be2vx$();
      this.list.nodePool_8be2vx$.push_11rb$(this);
    }
    var prevNode = get_value_0(this.prev);
    var nextNode = get_value_0(this.next);
    this.list.sizeCount_8be2vx$.decrementAndGet();
    if (nextNode == null) {
      set_value(this.list.tail_8be2vx$, prevNode);
    } else {
      set_value(nextNode.prev, prevNode);
    }
    if (prevNode == null) {
      set_value(this.list.head_8be2vx$, nextNode);
    } else {
      set_value(prevNode.next, nextNode);
    }
  };
  AbstractSharedLinkedList$Node.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Node',
    interfaces: []
  };
  AbstractSharedLinkedList.prototype.makeNode_1c3m6u$ = function (t) {
    var node = this.nodePool_8be2vx$.pop();
    node.recycle_8be2vx$();
    node.internalSet_1c3m6u$(t);
    return node;
  };
  AbstractSharedLinkedList.prototype.internalAddAll_eqrwgj$ = function (elements) {
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.internalAdd_w85adh$(this.makeNode_1c3m6u$(element));
    }
    return true;
  };
  AbstractSharedLinkedList.prototype.internalNodeAt_kcn2v3$ = function (i) {
    var tmp$;
    if (i >= get_value(this.sizeCount_8be2vx$)) {
      throw IllegalArgumentException_init('index ' + i + ' ge ' + get_value(this.sizeCount_8be2vx$));
    }
    var node = get_value_0(this.head_8be2vx$);
    var nodeCount = 0;
    while (node != null) {
      if (i === (tmp$ = nodeCount, nodeCount = tmp$ + 1 | 0, tmp$)) {
        return node;
      }
      node = get_value_0(node.next);
    }
    throw IllegalStateException_init('Bad math');
  };
  AbstractSharedLinkedList.prototype.internalRemoveAt_kcn2v3$ = function (i) {
    var node = this.internalNodeAt_kcn2v3$(i);
    var nodeValue = node.nodeValue;
    node.internalRemove_vft4zs$();
    return nodeValue;
  };
  AbstractSharedLinkedList.prototype.internalAdd_w85adh$ = function (node) {
    node.checkNotRemoved_8be2vx$();
    freeze(node);
    if (get_value(this.sizeCount_8be2vx$) === 0) {
      set_value(this.head_8be2vx$, node);
      set_value(this.tail_8be2vx$, node);
    } else {
      var prev = get_value_0(this.tail_8be2vx$);
      set_value(ensureNotNull(prev).next, node);
      set_value(node.prev, prev);
      set_value(this.tail_8be2vx$, node);
    }
    this.sizeCount_8be2vx$.incrementAndGet();
    return true;
  };
  AbstractSharedLinkedList.prototype.internalFindFirstIndex_1c3m6u$ = function (value) {
    var node = get_value_0(this.head_8be2vx$);
    var nodeCount = 0;
    while (node != null) {
      if (equals(node.nodeValue, value)) {
        return new AbstractSharedLinkedList$NodeResult(nodeCount, node);
      }
      node = get_value_0(node.next);
      nodeCount = nodeCount + 1 | 0;
    }
    return new AbstractSharedLinkedList$NodeResult(-1, null);
  };
  AbstractSharedLinkedList.prototype.internalFindFirst_1c3m6u$ = function (value) {
    return this.internalFindFirstIndex_1c3m6u$(value).node;
  };
  AbstractSharedLinkedList.prototype.internalRemove_1c3m6u$ = function (value) {
    var tmp$;
    var node = this.internalFindFirst_1c3m6u$(value);
    if (node == null) {
      tmp$ = false;
    } else {
      node.internalRemove_vft4zs$();
      tmp$ = true;
    }
    return tmp$;
  };
  function AbstractSharedLinkedList$NodeResult(index, node) {
    this.index = index;
    this.node = node;
  }
  AbstractSharedLinkedList$NodeResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NodeResult',
    interfaces: []
  };
  AbstractSharedLinkedList$NodeResult.prototype.component1 = function () {
    return this.index;
  };
  AbstractSharedLinkedList$NodeResult.prototype.component2 = function () {
    return this.node;
  };
  AbstractSharedLinkedList$NodeResult.prototype.copy_sp4ycz$ = function (index, node) {
    return new AbstractSharedLinkedList$NodeResult(index === void 0 ? this.index : index, node === void 0 ? this.node : node);
  };
  AbstractSharedLinkedList$NodeResult.prototype.toString = function () {
    return 'NodeResult(index=' + Kotlin.toString(this.index) + (', node=' + Kotlin.toString(this.node)) + ')';
  };
  AbstractSharedLinkedList$NodeResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.index) | 0;
    result = result * 31 + Kotlin.hashCode(this.node) | 0;
    return result;
  };
  AbstractSharedLinkedList$NodeResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.index, other.index) && Kotlin.equals(this.node, other.node)))));
  };
  AbstractSharedLinkedList.prototype.debugPrint = function () {
    var sb = StringBuilder_init();
    var node = get_value_0(this.head_8be2vx$);
    while (node != null) {
      sb.append_pdl1vj$('val: ' + node.nodeValue + ', pref: ' + toString(get_value_0(node.prev)) + ', next: ' + toString(get_value_0(node.next)) + '\n');
      node = get_value_0(node.next);
    }
    return sb.toString();
  };
  AbstractSharedLinkedList.prototype.lock_8be2vx$ = function () {
    this.lock_8uoc56$_0.lock();
  };
  AbstractSharedLinkedList.prototype.unlock_8be2vx$ = function () {
    this.lock_8uoc56$_0.unlock();
  };
  AbstractSharedLinkedList.prototype.withLock_50n1m8$ = defineInlineFunction('stately-stately-collections-js-legacy.co.touchlab.stately.collections.AbstractSharedLinkedList.withLock_50n1m8$', function (updated, proc) {
    this.lock_8be2vx$();
    try {
      return proc();
    }finally {
      if (updated) {
        this.updated();
      }
      this.unlock_8be2vx$();
    }
  });
  function AbstractSharedLinkedList$nodePool$lambda(this$AbstractSharedLinkedList) {
    return function () {
      return new AbstractSharedLinkedList$Node(this$AbstractSharedLinkedList);
    };
  }
  AbstractSharedLinkedList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AbstractSharedLinkedList',
    interfaces: [MutableList]
  };
  function SharedLruCache(maxCacheSize, onRemove) {
    if (onRemove === void 0)
      onRemove = SharedLruCache_init$lambda;
    this.maxCacheSize_0 = maxCacheSize;
    this.onRemove_0 = onRemove;
    this.lock_0 = new Lock();
    this.cacheMap_0 = new SharedHashMap(this.maxCacheSize_0);
    this.cacheList_0 = new SharedLinkedList(20);
    freeze(this);
  }
  SharedLruCache.prototype.put_xwzc9p$ = function (key, value) {
    var resultValue = {v: null};
    var removeCollection = ArrayList_init();
    this.lock_0.lock();
    try {
      var tmp$;
      var cacheEntry = this.cacheMap_0.get_11rb$(key);
      var node;
      var result;
      if (cacheEntry != null) {
        if (!equals(value, cacheEntry.v)) {
          tmp$ = cacheEntry.v;
        } else {
          tmp$ = null;
        }
        result = tmp$;
        node = cacheEntry.node;
        node.readd();
      } else {
        result = null;
        node = this.cacheList_0.addNode_11rb$(key);
      }
      this.cacheMap_0.put_xwzc9p$(key, new SharedLruCache$CacheEntry(value, node));
      while (this.cacheList_0.size > this.maxCacheSize_0) {
        var key_0 = this.cacheList_0.removeAt_za3lpa$(0);
        var entry = this.cacheMap_0.remove_11rb$(key_0);
        if (entry != null) {
          removeCollection.add_11rb$(new SharedLruCache$LruEntry(key_0, entry.v));
        }
      }
      resultValue.v = result;
    }finally {
      this.lock_0.unlock();
    }
    var action = this.onRemove_0;
    var tmp$_0;
    tmp$_0 = removeCollection.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      action(element);
    }
    return resultValue.v;
  };
  SharedLruCache.prototype.remove_iuyhfk$$default = function (key, skipCallback) {
    var tmp$;
    var removeEntry = {v: null};
    this.lock_0.lock();
    try {
      var entry = this.cacheMap_0.remove_11rb$(key);
      if (entry != null) {
        entry.node.remove_6taknv$();
        removeEntry.v = new SharedLruCache$LruEntry(key, entry.v);
      }
    }finally {
      this.lock_0.unlock();
    }
    if (!skipCallback && removeEntry.v != null) {
      this.onRemove_0(ensureNotNull(removeEntry.v));
    }
    return (tmp$ = removeEntry.v) != null ? tmp$.value : null;
  };
  Object.defineProperty(SharedLruCache.prototype, 'entries', {
    configurable: true,
    get: function () {
      this.lock_0.lock();
      try {
        return this.internalAll_0();
      }finally {
        this.lock_0.unlock();
      }
    }
  });
  SharedLruCache.prototype.removeAll_6taknv$$default = function (skipCallback) {
    var removeCollection = {v: null};
    this.lock_0.lock();
    try {
      if (!skipCallback) {
        removeCollection.v = this.internalAll_0();
      }
      this.cacheMap_0.clear();
      this.cacheList_0.clear();
    }finally {
      this.lock_0.unlock();
    }
    if (removeCollection.v != null) {
      var $receiver = ensureNotNull(removeCollection.v);
      var action = this.onRemove_0;
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        action(element);
      }
    }
  };
  SharedLruCache.prototype.get_11rb$ = function (key) {
    this.lock_0.lock();
    try {
      var tmp$;
      var cacheEntry = this.cacheMap_0.get_11rb$(key);
      if (cacheEntry != null) {
        ensureNotNull(cacheEntry).node.readd();
        tmp$ = cacheEntry.v;
      } else {
        tmp$ = null;
      }
      return tmp$;
    }finally {
      this.lock_0.unlock();
    }
  };
  SharedLruCache.prototype.exists_11rb$ = function (key) {
    var withLock_0$result;
    this.lock_0.lock();
    try {
      withLock_0$result = this.cacheMap_0.get_11rb$(key) != null;
    }finally {
      this.lock_0.unlock();
    }
    return withLock_0$result;
  };
  Object.defineProperty(SharedLruCache.prototype, 'size', {
    configurable: true,
    get: function () {
      var withLock_0$result;
      this.lock_0.lock();
      try {
        withLock_0$result = this.cacheMap_0.size;
      }finally {
        this.lock_0.unlock();
      }
      return withLock_0$result;
    }
  });
  function SharedLruCache$CacheEntry(v, node) {
    this.v = v;
    this.node = node;
  }
  SharedLruCache$CacheEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CacheEntry',
    interfaces: []
  };
  SharedLruCache$CacheEntry.prototype.component1 = function () {
    return this.v;
  };
  SharedLruCache$CacheEntry.prototype.component2 = function () {
    return this.node;
  };
  SharedLruCache$CacheEntry.prototype.copy_hr2xhw$ = function (v, node) {
    return new SharedLruCache$CacheEntry(v === void 0 ? this.v : v, node === void 0 ? this.node : node);
  };
  SharedLruCache$CacheEntry.prototype.toString = function () {
    return 'CacheEntry(v=' + Kotlin.toString(this.v) + (', node=' + Kotlin.toString(this.node)) + ')';
  };
  SharedLruCache$CacheEntry.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.v) | 0;
    result = result * 31 + Kotlin.hashCode(this.node) | 0;
    return result;
  };
  SharedLruCache$CacheEntry.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.v, other.v) && Kotlin.equals(this.node, other.node)))));
  };
  function SharedLruCache$LruEntry(key, value) {
    this.key_dgtmt3$_0 = key;
    this.value_jlni79$_0 = value;
  }
  Object.defineProperty(SharedLruCache$LruEntry.prototype, 'key', {
    get: function () {
      return this.key_dgtmt3$_0;
    }
  });
  Object.defineProperty(SharedLruCache$LruEntry.prototype, 'value', {
    get: function () {
      return this.value_jlni79$_0;
    }
  });
  SharedLruCache$LruEntry.prototype.setValue_11rc$ = function (newValue) {
    throw UnsupportedOperationException_init();
  };
  SharedLruCache$LruEntry.prototype.toString = function () {
    return 'LruEntry(key=' + this.key + ', value=' + this.value + ')';
  };
  SharedLruCache$LruEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LruEntry',
    interfaces: [MutableMap$MutableEntry]
  };
  SharedLruCache.prototype.internalAll_0 = function () {
    var set = HashSet_init(this.cacheList_0.size);
    var $receiver = this.cacheList_0.iterator();
    while ($receiver.hasNext()) {
      var element = $receiver.next();
      set.add_11rb$(new SharedLruCache$LruEntry(element, ensureNotNull(this.cacheMap_0.get_11rb$(element)).v));
    }
    return set;
  };
  SharedLruCache.prototype.withLock_0 = function (proc) {
    this.lock_0.lock();
    try {
      return proc();
    }finally {
      this.lock_0.unlock();
    }
  };
  SharedLruCache.prototype.printDebug_8be2vx$ = function () {
    println('CACHELIST');
    var tmp$;
    tmp$ = this.cacheList_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      println(element);
    }
    println('CACHEMAP');
    var tmp$_0;
    tmp$_0 = this.cacheMap_0.entries.iterator();
    while (tmp$_0.hasNext()) {
      var element_0 = tmp$_0.next();
      println(element_0);
    }
  };
  function SharedLruCache_init$lambda(it) {
    return Unit;
  }
  SharedLruCache.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SharedLruCache',
    interfaces: [LruCache]
  };
  function LruCache() {
  }
  LruCache.prototype.remove_iuyhfk$ = function (key, skipCallback, callback$default) {
    if (skipCallback === void 0)
      skipCallback = false;
    return callback$default ? callback$default(key, skipCallback) : this.remove_iuyhfk$$default(key, skipCallback);
  };
  LruCache.prototype.removeAll_6taknv$ = function (skipCallback, callback$default) {
    if (skipCallback === void 0)
      skipCallback = false;
    callback$default ? callback$default(skipCallback) : this.removeAll_6taknv$$default(skipCallback);
  };
  LruCache.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LruCache',
    interfaces: []
  };
  function SharedSet() {
    this.backingMap_0 = frozenHashMap();
    freeze(this);
  }
  SharedSet.prototype.add_11rb$ = function (element) {
    var result = this.backingMap_0.containsKey_11rb$(element);
    this.backingMap_0.put_xwzc9p$(element, Unit);
    return !result;
  };
  SharedSet.prototype.addAll_brywnq$ = function (elements) {
    var tmp$;
    var accumulator = false;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var b = accumulator;
      var result = this.backingMap_0.containsKey_11rb$(element);
      this.backingMap_0.put_xwzc9p$(element, Unit);
      accumulator = b || result;
    }
    return accumulator;
  };
  SharedSet.prototype.clear = function () {
    this.backingMap_0.clear();
  };
  SharedSet.prototype.remove_11rb$ = function (element) {
    var result = this.backingMap_0.containsKey_11rb$(element);
    this.backingMap_0.remove_11rb$(element);
    return result;
  };
  SharedSet.prototype.removeAll_brywnq$ = function (elements) {
    var tmp$;
    var accumulator = false;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var b = accumulator;
      var result = this.backingMap_0.containsKey_11rb$(element);
      this.backingMap_0.remove_11rb$(element);
      accumulator = b || result;
    }
    return accumulator;
  };
  SharedSet.prototype.retainAll_brywnq$ = function (elements) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'not implemented');
  };
  Object.defineProperty(SharedSet.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.backingMap_0.size;
    }
  });
  SharedSet.prototype.contains_11rb$ = function (element) {
    return this.backingMap_0.containsKey_11rb$(element);
  };
  SharedSet.prototype.containsAll_brywnq$ = function (elements) {
    return this.backingMap_0.keys.containsAll_brywnq$(elements);
  };
  SharedSet.prototype.isEmpty = function () {
    return this.backingMap_0.isEmpty();
  };
  SharedSet.prototype.iterator = function () {
    return this.backingMap_0.keys.iterator();
  };
  SharedSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SharedSet',
    interfaces: [MutableSet]
  };
  function frozenCopyOnWriteList(collection) {
    if (collection === void 0)
      collection = null;
    throw UnsupportedOperationException_init_0('Not for JS');
  }
  var package$co = _.co || (_.co = {});
  var package$touchlab = package$co.touchlab || (package$co.touchlab = {});
  var package$stately = package$touchlab.stately || (package$touchlab.stately = {});
  var package$collections = package$stately.collections || (package$stately.collections = {});
  package$collections.frozenLinkedList_jjc7i3$ = frozenLinkedList;
  package$collections.frozenHashMap_xf5xz2$ = frozenHashMap;
  package$collections.frozenHashSet_287e2$ = frozenHashSet;
  package$collections.frozenLruCache_icnq6z$ = frozenLruCache;
  package$collections.toList_35ci02$ = toList;
  $$importsForInline$$['stately-stately-concurrency-js-legacy'] = $module$stately_stately_concurrency_js_legacy;
  package$collections.ObjectPool = ObjectPool;
  SharedHashMap.Entry = SharedHashMap$Entry;
  $$importsForInline$$['stately-stately-collections-js-legacy'] = _;
  package$collections.SharedHashMap = SharedHashMap;
  SharedLinkedList.NodeIterator = SharedLinkedList$NodeIterator;
  SharedLinkedList.LLIterator = SharedLinkedList$LLIterator;
  package$collections.SharedLinkedList = SharedLinkedList;
  package$collections.CopyOnIterateLinkedList = CopyOnIterateLinkedList;
  AbstractSharedLinkedList.Node = AbstractSharedLinkedList$Node;
  AbstractSharedLinkedList.NodeResult = AbstractSharedLinkedList$NodeResult;
  package$collections.AbstractSharedLinkedList = AbstractSharedLinkedList;
  SharedLruCache.CacheEntry = SharedLruCache$CacheEntry;
  SharedLruCache.LruEntry = SharedLruCache$LruEntry;
  package$collections.SharedLruCache = SharedLruCache;
  package$collections.LruCache = LruCache;
  package$collections.SharedSet = SharedSet;
  package$collections.frozenCopyOnWriteList_4l0ny6$ = frozenCopyOnWriteList;
  SharedLruCache.prototype.remove_iuyhfk$ = LruCache.prototype.remove_iuyhfk$;
  SharedLruCache.prototype.removeAll_6taknv$ = LruCache.prototype.removeAll_6taknv$;
  Kotlin.defineModule('stately-stately-collections-js-legacy', _);
  return _;
}));

//# sourceMappingURL=stately-stately-collections-js-legacy.js.map
