/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.okio.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/serialization/json/okio/internal/JsonToOkioStreamWriter;", "Lkotlinx/serialization/json/internal/JsonWriter;", "target", "Lokio/BufferedSink;", "(Lokio/BufferedSink;)V", "release", "", "write", "text", "", "writeChar", "char", "", "writeLong", "value", "", "writeQuoted", "kotlinx-serialization-json-okio"})
public final class JsonToOkioStreamWriter
implements JsonWriter {
    @NotNull
    private final BufferedSink target;

    public JsonToOkioStreamWriter(@NotNull BufferedSink target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    public void writeChar(char c) {
        this.target.writeUtf8CodePoint((int)c);
    }

    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.target.writeUtf8(text);
    }

    public void writeQuoted(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.target.writeUtf8CodePoint(34);
        int lastPos = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (c >= StringOpsKt.getESCAPE_STRINGS().length || StringOpsKt.getESCAPE_STRINGS()[c] == null) continue;
            this.target.writeUtf8(text, lastPos, i);
            String string = StringOpsKt.getESCAPE_STRINGS()[c];
            Intrinsics.checkNotNull((Object)string);
            this.target.writeUtf8(string);
            lastPos = i + 1;
        }
        if (lastPos != 0) {
            this.target.writeUtf8(text, lastPos, text.length());
        } else {
            this.target.writeUtf8(text);
        }
        this.target.writeUtf8CodePoint(34);
    }

    public void release() {
    }
}

