(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-json-js-legacy', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-json-js-legacy'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'.");
    }
    if (typeof this['kotlinx-serialization-kotlinx-serialization-json-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'. Its dependency 'kotlinx-serialization-kotlinx-serialization-json-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-json-js-legacy' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'.");
    }
    if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'.");
    }
    root['kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'] = factory(typeof this['kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'] === 'undefined' ? {} : this['kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy'], kotlin, this['kotlinx-serialization-kotlinx-serialization-json-js-legacy'], this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var encodeByWriter = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal.encodeByWriter_12q8ao$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var decodeByReader = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal.decodeByReader_5v3gj3$;
  var DecodeSequenceMode = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.DecodeSequenceMode;
  var decodeToSequenceByReader = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal.decodeToSequenceByReader_i2njli$;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal;
  var ensureNotNull = Kotlin.ensureNotNull;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var JsonWriter = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal.JsonWriter;
  var toChar = Kotlin.toChar;
  var SerialReader = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.internal.SerialReader;
  function encodeToBufferedSink($receiver, serializer, value, target) {
    var writer = new JsonToOkioStreamWriter(target);
    try {
      encodeByWriter($receiver, writer, serializer, value);
    }finally {
      writer.release();
    }
  }
  var encodeToBufferedSink_0 = defineInlineFunction('kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy.kotlinx.serialization.json.okio.encodeToBufferedSink_5so27g$', wrapFunction(function () {
    var getReifiedTypeParameterKType = Kotlin.getReifiedTypeParameterKType;
    var encodeToBufferedSink = _.kotlinx.serialization.json.okio.encodeToBufferedSink_imfgkp$;
    var serializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.serializer_ca95z9$;
    var KSerializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.KSerializer;
    var throwCCE = Kotlin.throwCCE;
    return function (T_0, isT, $receiver, value, target) {
      var $receiver_0 = $receiver.serializersModule;
      var tmp$;
      encodeToBufferedSink($receiver, Kotlin.isType(tmp$ = serializer($receiver_0, getReifiedTypeParameterKType(T_0)), KSerializer) ? tmp$ : throwCCE(), value, target);
    };
  }));
  function decodeFromBufferedSource($receiver, deserializer, source) {
    return decodeByReader($receiver, deserializer, new OkioSerialReader(source));
  }
  var decodeFromBufferedSource_0 = defineInlineFunction('kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy.kotlinx.serialization.json.okio.decodeFromBufferedSource_njeqbq$', wrapFunction(function () {
    var getReifiedTypeParameterKType = Kotlin.getReifiedTypeParameterKType;
    var decodeFromBufferedSource = _.kotlinx.serialization.json.okio.decodeFromBufferedSource_5nel6q$;
    var serializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.serializer_ca95z9$;
    var KSerializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.KSerializer;
    var throwCCE = Kotlin.throwCCE;
    return function (T_0, isT, $receiver, source) {
      var $receiver_0 = $receiver.serializersModule;
      var tmp$;
      return decodeFromBufferedSource($receiver, Kotlin.isType(tmp$ = serializer($receiver_0, getReifiedTypeParameterKType(T_0)), KSerializer) ? tmp$ : throwCCE(), source);
    };
  }));
  function decodeBufferedSourceToSequence($receiver, source, deserializer, format) {
    if (format === void 0)
      format = DecodeSequenceMode.AUTO_DETECT;
    return decodeToSequenceByReader($receiver, new OkioSerialReader(source), deserializer, format);
  }
  var decodeBufferedSourceToSequence_0 = defineInlineFunction('kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy.kotlinx.serialization.json.okio.decodeBufferedSourceToSequence_c4b8jz$', wrapFunction(function () {
    var DecodeSequenceMode = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-json-js-legacy'].kotlinx.serialization.json.DecodeSequenceMode;
    var getReifiedTypeParameterKType = Kotlin.getReifiedTypeParameterKType;
    var decodeBufferedSourceToSequence = _.kotlinx.serialization.json.okio.decodeBufferedSourceToSequence_szjwcn$;
    var serializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.serializer_ca95z9$;
    var KSerializer = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'].kotlinx.serialization.KSerializer;
    var throwCCE = Kotlin.throwCCE;
    return function (T_0, isT, $receiver, source, format) {
      if (format === void 0)
        format = DecodeSequenceMode.AUTO_DETECT;
      var $receiver_0 = $receiver.serializersModule;
      var tmp$;
      return decodeBufferedSourceToSequence($receiver, source, Kotlin.isType(tmp$ = serializer($receiver_0, getReifiedTypeParameterKType(T_0)), KSerializer) ? tmp$ : throwCCE(), format);
    };
  }));
  function JsonToOkioStreamWriter(target) {
    this.target_0 = target;
  }
  JsonToOkioStreamWriter.prototype.writeLong_s8cxhz$ = function (value) {
    this.write_61zpoe$(value.toString());
  };
  JsonToOkioStreamWriter.prototype.writeChar_s8itvh$ = function (char) {
    this.target_0.writeUtf8CodePoint_za3lpa$(char | 0);
  };
  JsonToOkioStreamWriter.prototype.write_61zpoe$ = function (text) {
    this.target_0.writeUtf8_61zpoe$(text);
  };
  JsonToOkioStreamWriter.prototype.writeQuoted_61zpoe$ = function (text) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    this.target_0.writeUtf8CodePoint_za3lpa$(34);
    var lastPos = 0;
    tmp$ = get_indices(text);
    tmp$_0 = tmp$.first;
    tmp$_1 = tmp$.last;
    tmp$_2 = tmp$.step;
    for (var i = tmp$_0; i <= tmp$_1; i += tmp$_2) {
      var c = text.charCodeAt(i) | 0;
      if (c < internal.ESCAPE_STRINGS.length && internal.ESCAPE_STRINGS[c] != null) {
        this.target_0.writeUtf8_3m52m6$(text, lastPos, i);
        this.target_0.writeUtf8_61zpoe$(ensureNotNull(internal.ESCAPE_STRINGS[c]));
        lastPos = i + 1 | 0;
      }
    }
    if (lastPos !== 0)
      this.target_0.writeUtf8_3m52m6$(text, lastPos, text.length);
    else
      this.target_0.writeUtf8_61zpoe$(text);
    this.target_0.writeUtf8CodePoint_za3lpa$(34);
  };
  JsonToOkioStreamWriter.prototype.release = function () {
  };
  JsonToOkioStreamWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsonToOkioStreamWriter',
    interfaces: [JsonWriter]
  };
  var SINGLE_CHAR_MAX_CODEPOINT;
  var HIGH_SURROGATE_HEADER;
  var LOW_SURROGATE_HEADER;
  function OkioSerialReader(source) {
    this.source_0 = source;
    this.bufferedChar_0 = null;
  }
  OkioSerialReader.prototype.read_8chfmy$ = function (buffer, bufferOffset, count) {
    var i = 0;
    if (this.bufferedChar_0 != null) {
      buffer[bufferOffset + i | 0] = ensureNotNull(this.bufferedChar_0);
      i = i + 1 | 0;
      this.bufferedChar_0 = null;
    }
    while (i < count && !this.source_0.exhausted()) {
      var codePoint = this.source_0.readUtf8CodePoint();
      if (codePoint <= 65535) {
        buffer[bufferOffset + i | 0] = toChar(codePoint);
        i = i + 1 | 0;
      } else {
        var upChar = toChar((codePoint >>> 10) + 55232 | 0);
        var lowChar = toChar((codePoint & 1023) + 56320 | 0);
        buffer[bufferOffset + i | 0] = upChar;
        i = i + 1 | 0;
        if (i < count) {
          buffer[bufferOffset + i | 0] = lowChar;
          i = i + 1 | 0;
        } else {
          this.bufferedChar_0 = lowChar;
        }
      }
    }
    return i > 0 ? i : -1;
  };
  OkioSerialReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OkioSerialReader',
    interfaces: [SerialReader]
  };
  var package$kotlinx = _.kotlinx || (_.kotlinx = {});
  var package$serialization = package$kotlinx.serialization || (package$kotlinx.serialization = {});
  var package$json = package$serialization.json || (package$serialization.json = {});
  var package$okio = package$json.okio || (package$json.okio = {});
  package$okio.encodeToBufferedSink_imfgkp$ = encodeToBufferedSink;
  $$importsForInline$$['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy;
  package$okio.decodeFromBufferedSource_5nel6q$ = decodeFromBufferedSource;
  package$okio.decodeBufferedSourceToSequence_szjwcn$ = decodeBufferedSourceToSequence;
  $$importsForInline$$['kotlinx-serialization-kotlinx-serialization-json-js-legacy'] = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy;
  var package$internal = package$okio.internal || (package$okio.internal = {});
  package$internal.JsonToOkioStreamWriter = JsonToOkioStreamWriter;
  package$internal.OkioSerialReader = OkioSerialReader;
  SINGLE_CHAR_MAX_CODEPOINT = 65535;
  HIGH_SURROGATE_HEADER = 55232;
  LOW_SURROGATE_HEADER = 56320;
  Kotlin.defineModule('kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlinx-serialization-kotlinx-serialization-json-okio-js-legacy.js.map
