/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.hocon.AbstractHoconEncoder;
import kotlinx.serialization.hocon.Hocon;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0006H\u0014R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/hocon/HoconConfigEncoder;", "Lkotlinx/serialization/hocon/AbstractHoconEncoder;", "hocon", "Lkotlinx/serialization/hocon/Hocon;", "configConsumer", "Lkotlin/Function1;", "Lcom/typesafe/config/ConfigValue;", "", "(Lkotlinx/serialization/hocon/Hocon;Lkotlin/jvm/functions/Function1;)V", "configMap", "", "", "encodeTaggedConfigValue", "tag", "value", "getCurrent", "kotlinx-serialization-hocon"})
public final class HoconConfigEncoder
extends AbstractHoconEncoder {
    @NotNull
    private final Map<String, ConfigValue> configMap;

    public HoconConfigEncoder(@NotNull Hocon hocon, @NotNull Function1<? super ConfigValue, Unit> configConsumer) {
        Intrinsics.checkNotNullParameter((Object)hocon, (String)"hocon");
        Intrinsics.checkNotNullParameter(configConsumer, (String)"configConsumer");
        super(hocon, configConsumer);
        this.configMap = new LinkedHashMap();
    }

    @Override
    protected void encodeTaggedConfigValue(@NotNull String tag, @NotNull ConfigValue value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.configMap.put(tag, value);
    }

    @Override
    @NotNull
    protected ConfigValue getCurrent() {
        ConfigObject configObject = ConfigValueFactory.fromMap(this.configMap);
        Intrinsics.checkNotNullExpressionValue((Object)configObject, (String)"fromMap(configMap)");
        return (ConfigValue)configObject;
    }
}

