/*
 * Decompiled with CFR 0.152.
 */
package klog;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import klog.KLog;
import klog.KLogFactory;
import klog.KLogWriters;
import klog.KMessageFormatters;
import klog.Level;
import klog.StatementContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001Bq\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00122\b\u0002\u0010\u0004\u001a,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\t\u0012,\b\u0002\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lklog/DefaultLogFactory;", "Lklog/KLogFactory;", "level", "Lklog/Level;", "formatter", "Lkotlin/Function5;", "", "", "Lklog/StatementContext;", "Lklog/KMessageFormatter;", "writer", "Lkotlin/Function4;", "", "Lklog/KLogWriter;", "(Lklog/Level;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function4;)V", "logs", "", "Lklog/KLog;", "applyToBranch", "tag", "toApply", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "get", "getLogs", "", "getParent", "klog"})
@SourceDebugExtension(value={"SMAP\nKLogFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLogFactory.kt\nklog/DefaultLogFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,54:1\n215#2,2:55\n*S KotlinDebug\n*F\n+ 1 KLogFactory.kt\nklog/DefaultLogFactory\n*L\n49#1:55,2\n*E\n"})
public class DefaultLogFactory
extends KLogFactory {
    @NotNull
    private Map<String, KLog> logs;

    public DefaultLogFactory(@NotNull Level level, @NotNull Function5<? super String, ? super Level, ? super String, ? super Throwable, ? super StatementContext, String> formatter, @NotNull Function4<? super String, ? super Level, ? super String, ? super Throwable, Unit> writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.logs = new LinkedHashMap();
        this.logs.put("", new KLog("", new KLog.Conf(level, writer, formatter, 0, null, 24, null)));
    }

    public /* synthetic */ DefaultLogFactory(Level level, Function5 function5, Function4 function4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            level = Level.WARN;
        }
        if ((n & 2) != 0) {
            function5 = KMessageFormatters.INSTANCE.getSimple();
        }
        if ((n & 4) != 0) {
            function4 = KLogWriters.INSTANCE.getNoop();
        }
        this(level, function5, function4);
    }

    @Override
    @NotNull
    public KLog get(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        KLog kLog = this.logs.get(tag);
        if (kLog == null) {
            KLog kLog2;
            KLog it = kLog2 = new KLog(tag, this.getParent(tag).getConf());
            boolean bl = false;
            this.logs.put(tag, it);
            kLog = kLog2;
        }
        return kLog;
    }

    private final KLog getParent(String tag) {
        String parentTag = StringsKt.substringBeforeLast((String)tag, (char)'.', (String)"");
        boolean bl = false;
        KLog kLog = this.logs.get(parentTag);
        if (kLog == null) {
            kLog = this.getParent(parentTag);
        }
        return kLog;
    }

    @Override
    @NotNull
    public Set<KLog> getLogs() {
        return CollectionsKt.toSet((Iterable)this.logs.values());
    }

    @Override
    public void applyToBranch(@NotNull String tag, @NotNull Function1<? super KLog, Unit> toApply) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(toApply, (String)"toApply");
        Map<String, KLog> $this$forEach$iv = this.logs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, KLog>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, KLog> element$iv;
            Map.Entry<String, KLog> it = element$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)tag) && !StringsKt.startsWith$default((String)it.getKey(), (String)(tag + '.'), (boolean)false, (int)2, null)) continue;
            toApply.invoke((Object)it.getValue());
        }
    }

    public DefaultLogFactory() {
        this(null, null, null, 7, null);
    }
}

