/*
 * Decompiled with CFR 0.152.
 */
package klog;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import klog.KLog;
import klog.KLogFactory;
import klog.KLogImpl;
import klog.KLogWriters;
import klog.KMessageFormatters;
import klog.Level;
import klog.StatementContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001Bq\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00122\b\u0002\u0010\u0004\u001a,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\t\u0012,\b\u0002\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\u0002\b\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lklog/DefaultLogFactory;", "Lklog/KLogFactory;", "level", "Lklog/Level;", "formatter", "Lkotlin/Function5;", "", "", "Lklog/StatementContext;", "Lklog/KMessageFormatter;", "writer", "Lkotlin/Function4;", "", "Lklog/KLogWriter;", "(Lklog/Level;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function4;)V", "logs", "", "Lklog/KLogImpl;", "applyToBranch", "tag", "toApply", "Lkotlin/Function1;", "Lklog/KLog;", "Lkotlin/ExtensionFunctionType;", "get", "getLogs", "", "getParent", "klog"})
public class DefaultLogFactory
extends KLogFactory {
    @NotNull
    private Map<String, KLogImpl> logs;

    public DefaultLogFactory(@NotNull Level level, @NotNull Function5<? super String, ? super Level, ? super String, ? super Throwable, ? super StatementContext, String> formatter, @NotNull Function4<? super String, ? super Level, ? super String, ? super Throwable, Unit> writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.logs = new LinkedHashMap();
        this.logs.put("", new KLogImpl("", new KLog.Conf(level, writer, formatter, 0, null, 24, null)));
    }

    public /* synthetic */ DefaultLogFactory(Level level, Function5 function5, Function4 function4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            level = Level.WARN;
        }
        if ((n & 2) != 0) {
            function5 = KMessageFormatters.INSTANCE.getSimple();
        }
        if ((n & 4) != 0) {
            function4 = KLogWriters.INSTANCE.getNoop();
        }
        this(level, function5, function4);
    }

    @Override
    @NotNull
    public KLog get(@NotNull String tag) {
        KLog kLog;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        KLogImpl kLogImpl = this.logs.get(tag);
        if (kLogImpl != null) {
            kLog = kLogImpl;
        } else {
            KLogImpl kLogImpl2;
            KLogImpl it = kLogImpl2 = new KLogImpl(tag, this.getParent(tag).getConf());
            boolean bl = false;
            this.logs.put(tag, it);
            kLog = kLogImpl2;
        }
        return kLog;
    }

    private final KLogImpl getParent(String tag) {
        String parentTag = StringsKt.substringBeforeLast((String)tag, (char)'.', (String)"");
        boolean bl = false;
        KLogImpl kLogImpl = this.logs.get(parentTag);
        if (kLogImpl == null) {
            kLogImpl = this.getParent(parentTag);
        }
        return kLogImpl;
    }

    @Override
    @NotNull
    public Set<KLog> getLogs() {
        return CollectionsKt.toSet((Iterable)this.logs.values());
    }

    @Override
    public void applyToBranch(@NotNull String tag, @NotNull Function1<? super KLog, Unit> toApply) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(toApply, (String)"toApply");
        Map<String, KLogImpl> $this$forEach$iv = this.logs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, KLogImpl>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, KLogImpl> element$iv;
            Map.Entry<String, KLogImpl> it = element$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getKey(), (Object)tag) && !StringsKt.startsWith$default((String)it.getKey(), (String)(tag + "."), (boolean)false, (int)2, null)) continue;
            toApply.invoke((Object)it.getValue());
        }
    }

    public DefaultLogFactory() {
        this(null, null, null, 7, null);
    }
}

